/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.entity;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.tools.module.PickarangModule;

public class PickarangEntity
extends Entity
implements IProjectile {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(PickarangEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> RETURNING = EntityDataManager.func_187226_a(PickarangEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected LivingEntity owner;
    private UUID ownerId;
    private int liveTime;
    private int slot;
    private int blockHitCount;
    private IntOpenHashSet entitiesHit;
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_BLOCKS_BROKEN = "hitCount";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";

    public PickarangEntity(EntityType<? extends PickarangEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public PickarangEntity(World worldIn, LivingEntity throwerIn) {
        super(PickarangModule.pickarangType, worldIn);
        this.func_70107_b(throwerIn.field_70165_t, throwerIn.field_70163_u + (double)throwerIn.func_70047_e(), throwerIn.field_70161_v);
        this.ownerId = throwerIn.func_110124_au();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vec3d vec3d = entityThrower.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, entityThrower.field_70122_E ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)PickarangEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.func_77946_l());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STACK, (Object)new ItemStack((IItemProvider)PickarangModule.pickarang));
        this.field_70180_af.func_187214_a(RETURNING, (Object)false);
    }

    protected void checkImpact() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Vec3d motion = this.func_213322_ci();
        Vec3d position = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d rayEnd = position.func_178787_e(motion);
        boolean doEntities = true;
        int tries = 100;
        while (this.func_70089_S() && !((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue()) {
            EntityRayTraceResult result;
            if (doEntities) {
                result = this.raycastEntities(position, rayEnd);
                if (result != null) {
                    this.onImpact((RayTraceResult)result);
                } else {
                    doEntities = false;
                }
            } else {
                result = this.field_70170_p.func_217299_a(new RayTraceContext(position, rayEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                    return;
                }
                this.onImpact((RayTraceResult)result);
            }
            if (tries-- > 0) continue;
            new RuntimeException("Pickarang hit way too much, this shouldn't happen").printStackTrace();
            return;
        }
    }

    @Nullable
    protected EntityRayTraceResult raycastEntities(Vec3d from, Vec3d to) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)from, (Vec3d)to, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> !(entity.func_175149_v() || !entity.func_70089_S() || !entity.func_70067_L() && !(entity instanceof PickarangEntity) || entity == this.getThrower() || this.entitiesHit != null && this.entitiesHit.contains(entity.func_145782_y())));
    }

    protected void onImpact(@Nonnull RayTraceResult result) {
        Entity hit;
        LivingEntity owner = this.getThrower();
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK && result instanceof BlockRayTraceResult) {
            BlockPos hit2 = ((BlockRayTraceResult)result).func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(hit2);
            if (this.getPiercingModifier() == 0 || state.func_185904_a().func_76218_k()) {
                this.addHit();
            }
            if (!(owner instanceof ServerPlayerEntity)) {
                return;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)owner;
            float hardness = state.func_185887_b((IBlockReader)this.field_70170_p, hit2);
            if ((double)hardness <= PickarangModule.maxHardness && hardness >= 0.0f) {
                ItemStack prev = player.func_184614_ca();
                player.func_184611_a(Hand.MAIN_HAND, this.getStack());
                if (player.field_71134_c.func_180237_b(hit2)) {
                    this.field_70170_p.func_217378_a(null, 2001, hit2, Block.func_196246_j((BlockState)state));
                } else {
                    this.clank();
                }
                this.setStack(player.func_184614_ca());
                player.func_184611_a(Hand.MAIN_HAND, prev);
            } else {
                this.clank();
            }
        } else if (result.func_216346_c() == RayTraceResult.Type.ENTITY && result instanceof EntityRayTraceResult && (hit = ((EntityRayTraceResult)result).func_216348_a()) != owner) {
            this.addHit(hit);
            if (hit instanceof PickarangEntity) {
                ((PickarangEntity)hit).setReturning();
                this.clank();
            } else {
                ItemStack pickarang = this.getStack();
                Multimap modifiers = pickarang.func_111283_C(EquipmentSlotType.MAINHAND);
                if (owner != null) {
                    ItemStack prev = owner.func_184614_ca();
                    owner.func_184611_a(Hand.MAIN_HAND, pickarang);
                    owner.func_110140_aT().func_111147_b(modifiers);
                    int ticksSinceLastSwing = owner.field_184617_aD;
                    owner.field_184617_aD = (int)(1.0 / owner.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0) + 1;
                    float prevHealth = hit instanceof LivingEntity ? ((LivingEntity)hit).func_110143_aJ() : 0.0f;
                    PickarangModule.setActivePickarang(this);
                    if (owner instanceof PlayerEntity) {
                        ((PlayerEntity)owner).func_71059_n(hit);
                    } else {
                        owner.func_70652_k(hit);
                    }
                    if (hit instanceof LivingEntity && ((LivingEntity)hit).func_110143_aJ() == prevHealth) {
                        this.clank();
                    }
                    PickarangModule.setActivePickarang(null);
                    owner.field_184617_aD = ticksSinceLastSwing;
                    this.setStack(owner.func_184614_ca());
                    owner.func_184611_a(Hand.MAIN_HAND, prev);
                    owner.func_110140_aT().func_111148_a(modifiers);
                } else {
                    AttributeMap map = new AttributeMap();
                    IAttributeInstance attack = map.func_111150_b(SharedMonsterAttributes.field_111264_e);
                    attack.func_111128_a(1.0);
                    map.func_111147_b(modifiers);
                    ItemStack stack = this.getStack();
                    stack.func_96631_a(1, this.field_70170_p.field_73012_v, null);
                    this.setStack(stack);
                    hit.func_70097_a(new IndirectEntityDamageSource("player", (Entity)this, (Entity)this).func_76349_b(), (float)attack.func_111126_e());
                }
            }
        }
    }

    public void spark() {
        this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_SPARK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void clank() {
        this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void addHit(Entity entity) {
        if (this.entitiesHit == null) {
            this.entitiesHit = new IntOpenHashSet(5);
        }
        this.entitiesHit.add(entity.func_145782_y());
        this.postHit();
    }

    public void postHit() {
        if ((this.entitiesHit == null ? 0 : this.entitiesHit.size()) + this.blockHitCount > this.getPiercingModifier()) {
            this.setReturning();
        } else if (this.getPiercingModifier() > 0) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.8));
        }
    }

    public void addHit() {
        ++this.blockHitCount;
        this.postHit();
    }

    protected void setReturning() {
        this.field_70180_af.func_187227_b(RETURNING, (Object)true);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70071_h_() {
        float drag;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (!((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue()) {
            this.checkImpact();
        }
        Vec3d vec3d = this.func_213322_ci();
        this.field_70165_t += vec3d.field_72450_a;
        this.field_70163_u += vec3d.field_72448_b;
        this.field_70161_v += vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)PickarangEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - vec3d.field_72450_a * 0.25, this.field_70163_u - vec3d.field_72448_b * 0.25, this.field_70161_v - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            drag = 0.8f;
        } else {
            drag = 0.99f;
        }
        this.func_213317_d(vec3d.func_186678_a((double)drag));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.func_70089_S()) {
            return;
        }
        boolean returning = (Boolean)this.field_70180_af.func_187225_a(RETURNING);
        ++this.liveTime;
        if (!returning) {
            if (this.liveTime > PickarangModule.timeout) {
                this.setReturning();
            }
            if (!this.field_70170_p.func_175723_af().func_177746_a(this.func_180425_c())) {
                this.spark();
            }
        } else {
            this.field_70145_X = true;
            ItemStack stack = this.getStack();
            int eff = this.getEfficiencyModifier();
            List items = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(2.0));
            List xp = this.field_70170_p.func_217357_a(ExperienceOrbEntity.class, this.func_174813_aQ().func_186662_g(2.0));
            Vec3d ourPos = this.func_174791_d();
            for (ItemEntity item : items) {
                if (item.func_184218_aH()) continue;
                item.func_184220_m((Entity)this);
                item.func_174867_a(2);
            }
            for (ExperienceOrbEntity xpOrb : xp) {
                if (xpOrb.func_184218_aH()) continue;
                xpOrb.func_184220_m((Entity)this);
                xpOrb.field_70532_c = 2;
            }
            LivingEntity owner = this.getThrower();
            if (owner == null || !owner.func_70089_S() || !(owner instanceof PlayerEntity)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(stack, 0.0f);
                    this.func_70106_y();
                }
                return;
            }
            Vec3d ownerPos = owner.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
            Vec3d motion = ownerPos.func_178788_d(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.func_189985_c() < motionMag) {
                PlayerEntity player = (PlayerEntity)owner;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(this.slot);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (!stack.func_190926_b()) {
                        if (player.func_70089_S() && stackInSlot.func_190926_b()) {
                            player.field_71071_by.func_70299_a(this.slot, stack);
                        } else if (!player.func_70089_S() || !player.field_71071_by.func_70441_a(stack)) {
                            player.func_71019_a(stack, false);
                        }
                    }
                    if (player.func_70089_S()) {
                        ItemStack drop;
                        for (ItemEntity item : items) {
                            if (!item.func_70089_S()) continue;
                            drop = item.func_92059_d();
                            if (!player.func_191521_c(drop)) {
                                player.func_71019_a(drop, false);
                            }
                            item.func_70106_y();
                        }
                        for (ExperienceOrbEntity xpOrb : xp) {
                            if (!xpOrb.func_70089_S()) continue;
                            xpOrb.func_70100_b_(player);
                        }
                        for (Entity riding : this.func_184188_bt()) {
                            if (!riding.func_70089_S()) continue;
                            if (riding instanceof ItemEntity) {
                                drop = ((ItemEntity)riding).func_92059_d();
                                if (!player.func_191521_c(drop)) {
                                    player.func_71019_a(drop, false);
                                }
                                riding.func_70106_y();
                                continue;
                            }
                            if (!(riding instanceof ExperienceOrbEntity)) continue;
                            riding.func_70100_b_(player);
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                this.func_213317_d(motion.func_72432_b().func_186678_a(0.7 + (double)((float)eff * 0.325f)));
            }
        }
    }

    @Nullable
    public LivingEntity getThrower() {
        if (this.owner == null && this.ownerId != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerId);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            } else {
                this.ownerId = null;
            }
        }
        return this.owner;
    }

    protected boolean func_184219_q(Entity passenger) {
        return super.func_184219_q(passenger) || passenger instanceof ItemEntity || passenger instanceof ExperienceOrbEntity;
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.PLAYERS;
    }

    public int getEfficiencyModifier() {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)this.getStack());
    }

    public int getPiercingModifier() {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)this.getStack());
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    public void setStack(ItemStack stack) {
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        this.field_70180_af.func_187227_b(RETURNING, (Object)compound.func_74767_n(TAG_RETURNING));
        this.liveTime = compound.func_74762_e(TAG_LIVE_TIME);
        this.blockHitCount = compound.func_74762_e(TAG_BLOCKS_BROKEN);
        this.slot = compound.func_74762_e(TAG_RETURN_SLOT);
        if (compound.func_74764_b(TAG_ITEM_STACK)) {
            this.setStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack((IItemProvider)PickarangModule.pickarang));
        }
        if (compound.func_150297_b("owner", 10)) {
            this.ownerId = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("owner"));
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        compound.func_74757_a(TAG_RETURNING, ((Boolean)this.field_70180_af.func_187225_a(RETURNING)).booleanValue());
        compound.func_74768_a(TAG_LIVE_TIME, this.liveTime);
        compound.func_74768_a(TAG_BLOCKS_BROKEN, this.blockHitCount);
        compound.func_74768_a(TAG_RETURN_SLOT, this.slot);
        compound.func_218657_a(TAG_ITEM_STACK, (INBT)this.getStack().serializeNBT());
        if (this.ownerId != null) {
            compound.func_218657_a("owner", (INBT)NBTUtil.func_186862_a((UUID)this.ownerId));
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

