/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import vazkii.quark.client.module.ImprovedTooltipsModule;

public class MapTooltips {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof FilledMapItem && ImprovedTooltipsModule.mapRequireShift && !Screen.hasShiftDown()) {
            event.getToolTip().add(1, new TranslationTextComponent("quark.misc.map_shift", new Object[0]));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        if (!event.getStack().func_190926_b() && event.getStack().func_77973_b() instanceof FilledMapItem && (!ImprovedTooltipsModule.mapRequireShift || Screen.hasShiftDown())) {
            Minecraft mc = Minecraft.func_71410_x();
            MapData mapdata = FilledMapItem.func_195950_a((ItemStack)event.getStack(), (World)mc.field_71441_e);
            if (mapdata == null) {
                return;
            }
            GlStateManager.pushMatrix();
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            int pad = 7;
            float size = 135.0f;
            float scale = 0.5f;
            GlStateManager.translatef((float)event.getX(), (float)((float)event.getY() - size * scale - 5.0f), (float)0.0f);
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)(-pad), (double)size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)size, (double)size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)size, (double)(-pad), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-pad), (double)(-pad), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }
}

