/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.EnchantmentScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.registries.GameData;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.client.module.ImprovedTooltipsModule;
import vazkii.quark.tools.module.AncientTomesModule;

public class EnchantedBookTooltips {
    private static List<ItemStack> testItems = null;
    private static Multimap<Enchantment, ItemStack> additionalStacks = null;
    private static final ThreadLocal<Enchantment> clueHolder = new ThreadLocal();
    private static final ThreadLocal<Integer> clueLevelHolder = ThreadLocal.withInitial(() -> 0);

    public static void reloaded() {
        additionalStacks = null;
        testItems = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Items.field_151134_bR || stack.func_77973_b() == AncientTomesModule.ancient_tome) {
            Minecraft mc = Minecraft.func_71410_x();
            List tooltip = event.getToolTip();
            int tooltipIndex = 0;
            List<EnchantmentData> enchants = EnchantedBookTooltips.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentData ed : enchants) {
                ITextComponent match = ed.field_76302_b.func_200305_d(ed.field_76303_c);
                while (tooltipIndex < tooltip.size()) {
                    if (((ITextComponent)tooltip.get(tooltipIndex)).equals(match)) {
                        List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(ed.field_76302_b);
                        if (items.isEmpty()) continue block0;
                        int len = 3 + items.size() * 9;
                        String spaces = "";
                        while (mc.field_71466_p.func_78256_a(spaces) < len) {
                            spaces = spaces + " ";
                        }
                        tooltip.add(tooltipIndex + 1, new StringTextComponent(spaces));
                        continue block0;
                    }
                    ++tooltipIndex;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> captureEnchantingData(List<String> list, EnchantmentScreen screen, Enchantment enchantment, int level) {
        ItemStack last = screen.field_147077_B;
        if (!last.func_190926_b() && last.func_77973_b() == Items.field_151122_aG) {
            clueHolder.set(enchantment);
            clueLevelHolder.set(level);
            if (enchantment != null) {
                Minecraft mc = Minecraft.func_71410_x();
                String match = TextFormatting.func_110646_a((String)I18n.func_135052_a((String)"container.enchant.clue", (Object[])new Object[]{enchantment.func_200305_d(level).func_150254_d()}));
                for (int tooltipIndex = 0; tooltipIndex < list.size(); ++tooltipIndex) {
                    String line = TextFormatting.func_110646_a((String)list.get(tooltipIndex));
                    if (line == null || !line.equals(match)) continue;
                    List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(enchantment);
                    if (items.isEmpty()) break;
                    int len = 3 + items.size() * 9;
                    String spaces = "";
                    while (mc.field_71466_p.func_78256_a(spaces) < len) {
                        spaces = spaces + " ";
                    }
                    list.add(tooltipIndex + 1, spaces);
                    break;
                }
            }
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        Enchantment enchantment = clueHolder.get();
        int level = clueLevelHolder.get();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)event.getX(), (float)(event.getY() + 12), (float)0.0f);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        List tooltip = event.getLines();
        if (enchantment != null) {
            clueHolder.remove();
            clueLevelHolder.remove();
            String match = TextFormatting.func_110646_a((String)I18n.func_135052_a((String)"container.enchant.clue", (Object[])new Object[]{enchantment.func_200305_d(level).func_150254_d()}));
            for (int tooltipIndex = 0; tooltipIndex < tooltip.size(); ++tooltipIndex) {
                String line = TextFormatting.func_110646_a((String)((String)tooltip.get(tooltipIndex)));
                if (line == null || !line.equals(match)) continue;
                int drawn = 0;
                List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(enchantment);
                for (ItemStack testStack : items) {
                    mc.func_175599_af().func_175042_a(testStack, 6 + drawn * 18, tooltipIndex * 20 - 2);
                    ++drawn;
                }
                break;
            }
        } else if (stack.func_77973_b() == Items.field_151134_bR || stack.func_77973_b() == AncientTomesModule.ancient_tome) {
            List<EnchantmentData> enchants = EnchantedBookTooltips.getEnchantedBookEnchantments(stack);
            block2: for (EnchantmentData ed : enchants) {
                String match = ed.field_76302_b.func_200305_d(ed.field_76303_c).getString();
                for (int tooltipIndex = 0; tooltipIndex < tooltip.size(); ++tooltipIndex) {
                    String line = TextFormatting.func_110646_a((String)((String)tooltip.get(tooltipIndex)));
                    if (line == null || !line.equals(match)) continue;
                    int drawn = 0;
                    List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(ed.field_76302_b);
                    for (ItemStack testStack : items) {
                        mc.func_175599_af().func_175042_a(testStack, 6 + drawn * 18, tooltipIndex * 20 - 2);
                        ++drawn;
                    }
                    continue block2;
                }
            }
        }
        GlStateManager.popMatrix();
    }

    public static List<ItemStack> getItemsForEnchantment(Enchantment e) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : EnchantedBookTooltips.getTestItems()) {
            Item item = stack.func_77973_b();
            if (item instanceof QuarkItem && !((QuarkItem)item).isEnabled() || stack.func_190926_b() || !e.func_92089_a(stack)) continue;
            list.add(stack);
        }
        if (EnchantedBookTooltips.getAdditionalStacks().containsKey((Object)e)) {
            list.addAll(EnchantedBookTooltips.getAdditionalStacks().get((Object)e));
        }
        return list;
    }

    public static List<EnchantmentData> getEnchantedBookEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        ArrayList<EnchantmentData> retList = new ArrayList<EnchantmentData>(enchantments.size());
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment == null) continue;
            int level = (Integer)enchantments.get(enchantment);
            retList.add(new EnchantmentData(enchantment, level));
        }
        return retList;
    }

    private static Multimap<Enchantment, ItemStack> getAdditionalStacks() {
        if (additionalStacks == null) {
            EnchantedBookTooltips.computeAdditionalStacks();
        }
        return additionalStacks;
    }

    private static List<ItemStack> getTestItems() {
        if (testItems == null) {
            EnchantedBookTooltips.computeTestItems();
        }
        return testItems;
    }

    private static void computeTestItems() {
        testItems = Lists.newArrayList();
        for (String loc : ImprovedTooltipsModule.enchantingStacks) {
            Item item = (Item)GameData.getWrapper(Item.class).func_82594_a(new ResourceLocation(loc));
            if (item == null) continue;
            testItems.add(new ItemStack((IItemProvider)item));
        }
    }

    private static void computeAdditionalStacks() {
        additionalStacks = HashMultimap.create();
        for (String s : ImprovedTooltipsModule.enchantingAdditionalStacks) {
            if (!s.contains("=")) continue;
            String[] tokens = s.split("=");
            String left = tokens[0];
            String right = tokens[1];
            Enchantment ench = (Enchantment)GameData.getWrapper(Enchantment.class).func_82594_a(new ResourceLocation(left));
            if (ench == null) continue;
            for (String itemId : tokens = right.split(",")) {
                Item item = (Item)GameData.getWrapper(Item.class).func_82594_a(new ResourceLocation(itemId));
                if (item == null) continue;
                additionalStacks.put((Object)ench, (Object)new ItemStack((IItemProvider)item));
            }
        }
    }
}

