/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.Module;
import vazkii.quark.building.block.VariantChestBlock;
import vazkii.quark.building.tile.VariantTrappedChestTileEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IBlockItemProvider.class)
public class VariantTrappedChestBlock
extends TrappedChestBlock
implements IBlockItemProvider,
IQuarkBlock {
    public final String type;
    private final Module module;
    private BooleanSupplier enabledSupplier = () -> true;
    public final ResourceLocation modelNormal;
    public final ResourceLocation modelDouble;

    public VariantTrappedChestBlock(String type, Module module, Block.Properties props) {
        super(props);
        RegistryHelper.registerBlock((Block)this, (String)(type + "_trapped_chest"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78028_d);
        this.type = type;
        this.module = module;
        String path = this instanceof Compat ? "compat/" : "";
        this.modelNormal = new ResourceLocation("quark", "textures/model/chest/" + path + type + "_trap.png");
        this.modelDouble = new ResourceLocation("quark", "textures/model/chest/" + path + type + "_trap_double.png");
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.module.enabled || group == ItemGroup.field_78027_g) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public VariantTrappedChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.module;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new VariantTrappedChestTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockItem provideItemBlock(Block block, Item.Properties props) {
        VariantChestBlock.setTEISR(props, this.modelNormal, this.modelDouble);
        return new BlockItem(block, props);
    }

    public static class Compat
    extends VariantTrappedChestBlock {
        public Compat(String type, String mod, Module module, Block.Properties props) {
            super(type, module, props);
            this.setCondition(() -> ModList.get().isLoaded(mod));
        }
    }
}

