/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.item.QuarkSpawnEggItem;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.world.config.EntitySpawnConfig;

public class EntitySpawnHandler {
    private static List<TrackedSpawnConfig> trackedSpawnConfigs = new LinkedList<TrackedSpawnConfig>();

    public static <T extends MobEntity> void registerSpawn(Module module, EntityType<T> entityType, EntityClassification classification, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate, EntitySpawnConfig config) {
        EntitySpawnPlacementRegistry.func_209343_a(entityType, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightMapType, placementPredicate);
        config.setModule(module);
        trackedSpawnConfigs.add(new TrackedSpawnConfig(entityType, classification, config));
    }

    public static void addEgg(EntityType<?> entityType, int color1, int color2, EntitySpawnConfig config) {
        EntitySpawnHandler.addEgg(entityType, color1, color2, config.module, config::isEnabled);
    }

    public static void addEgg(EntityType<?> entityType, int color1, int color2, Module module, BooleanSupplier enabledSupplier) {
        new QuarkSpawnEggItem(entityType, color1, color2, entityType.getRegistryName().func_110623_a() + "_spawn_egg", module, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setCondition(enabledSupplier);
    }

    public static void refresh() {
        for (TrackedSpawnConfig c : trackedSpawnConfigs) {
            c.refresh();
            for (Biome b : ForgeRegistries.BIOMES.getValues()) {
                List l = b.func_76747_a(c.classification);
                l.removeIf(e -> e.field_200702_b == c.entityType);
                if (!c.config.biomes.canSpawn(b)) continue;
                l.add(c.entry);
            }
        }
    }

    private static class TrackedSpawnConfig {
        final EntityType<?> entityType;
        final EntityClassification classification;
        final EntitySpawnConfig config;
        Biome.SpawnListEntry entry;

        TrackedSpawnConfig(EntityType<?> entityType, EntityClassification classification, EntitySpawnConfig config) {
            this.entityType = entityType;
            this.classification = classification;
            this.config = config;
            this.refresh();
        }

        void refresh() {
            this.entry = new Biome.SpawnListEntry(this.entityType, this.config.spawnWeight, Math.min(this.config.minGroupSize, this.config.maxGroupSize), Math.max(this.config.minGroupSize, this.config.maxGroupSize));
        }
    }
}

