/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.util;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.WorldInfo;
import vazkii.quark.base.util.DarkChunkProvider;

public class DarkWorld
implements IWorld {
    private final IWorld parent;
    private final AbstractChunkProvider provider;

    public DarkWorld(IWorld parent) {
        this.parent = parent;
        this.provider = new DarkChunkProvider(parent.func_72863_F());
    }

    public int func_175642_b(@Nonnull LightType type, @Nonnull BlockPos pos) {
        if (type == LightType.SKY) {
            return 0;
        }
        return this.parent.func_175642_b(type, pos);
    }

    public long func_72905_C() {
        return this.parent.func_72905_C();
    }

    @Nonnull
    public ITickList<Block> func_205220_G_() {
        return this.parent.func_205220_G_();
    }

    @Nonnull
    public ITickList<Fluid> func_205219_F_() {
        return this.parent.func_205219_F_();
    }

    @Nonnull
    public World func_201672_e() {
        return this.parent.func_201672_e();
    }

    @Nonnull
    public WorldInfo func_72912_H() {
        return this.parent.func_72912_H();
    }

    @Nonnull
    public DifficultyInstance func_175649_E(@Nonnull BlockPos pos) {
        return this.parent.func_175649_E(pos);
    }

    @Nonnull
    public AbstractChunkProvider func_72863_F() {
        return this.provider;
    }

    @Nonnull
    public Random func_201674_k() {
        return this.parent.func_201674_k();
    }

    public void func_195592_c(@Nonnull BlockPos pos, @Nonnull Block blockIn) {
        this.parent.func_195592_c(pos, blockIn);
    }

    @Nonnull
    public BlockPos func_175694_M() {
        return this.parent.func_175694_M();
    }

    public void func_184133_a(@Nullable PlayerEntity player, @Nonnull BlockPos pos, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, float volume, float pitch) {
        this.parent.func_184133_a(player, pos, soundIn, category, volume, pitch);
    }

    public void func_195594_a(@Nonnull IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.parent.func_195594_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, @Nonnull BlockPos pos, int data) {
        this.parent.func_217378_a(player, type, pos, data);
    }

    @Nullable
    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        return this.parent.func_175625_s(pos);
    }

    @Nonnull
    public BlockState func_180495_p(@Nonnull BlockPos pos) {
        return this.parent.func_180495_p(pos);
    }

    @Nonnull
    public IFluidState func_204610_c(@Nonnull BlockPos pos) {
        return this.parent.func_204610_c(pos);
    }

    @Nonnull
    public List<Entity> func_175674_a(@Nullable Entity entityIn, @Nonnull AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return this.parent.func_175674_a(entityIn, boundingBox, predicate);
    }

    @Nonnull
    public <T extends Entity> List<T> func_175647_a(@Nonnull Class<? extends T> clazz, @Nonnull AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return this.parent.func_175647_a(clazz, aabb, filter);
    }

    @Nonnull
    public List<? extends PlayerEntity> func_217369_A() {
        return this.parent.func_217369_A();
    }

    public int func_201669_a(@Nonnull BlockPos pos, int amount) {
        if (pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000) {
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return Math.max(this.func_175642_b(LightType.BLOCK, pos) - amount, 0);
        }
        return 0;
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, @Nonnull ChunkStatus requiredStatus, boolean nonnull) {
        return this.parent.func_217353_a(x, z, requiredStatus, nonnull);
    }

    @Nonnull
    public BlockPos func_205770_a(@Nonnull Heightmap.Type heightmapType, @Nonnull BlockPos pos) {
        return this.parent.func_205770_a(heightmapType, pos);
    }

    public int func_201676_a(@Nonnull Heightmap.Type heightmapType, int x, int z) {
        return this.parent.func_201676_a(heightmapType, x, z);
    }

    public int func_175657_ab() {
        return 0;
    }

    @Nonnull
    public WorldBorder func_175723_af() {
        return this.parent.func_175723_af();
    }

    public boolean func_201670_d() {
        return this.parent.func_201670_d();
    }

    public int func_181545_F() {
        return this.parent.func_181545_F();
    }

    @Nonnull
    public Dimension func_201675_m() {
        return this.parent.func_201675_m();
    }

    @Nonnull
    public Biome func_180494_b(@Nonnull BlockPos pos) {
        return this.parent.func_180494_b(pos);
    }

    public boolean func_180501_a(@Nonnull BlockPos pos, @Nonnull BlockState newState, int flags) {
        return this.parent.func_180501_a(pos, newState, flags);
    }

    public boolean func_217377_a(@Nonnull BlockPos pos, boolean isMoving) {
        return this.parent.func_217377_a(pos, isMoving);
    }

    public boolean func_175655_b(@Nonnull BlockPos pos, boolean dropBlock) {
        return this.parent.func_175655_b(pos, dropBlock);
    }

    public boolean func_217375_a(@Nonnull BlockPos pos, @Nonnull Predicate<BlockState> predicate) {
        return this.parent.func_217375_a(pos, predicate);
    }
}

