/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="quark")
public class MiscUtil {
    public static final ResourceLocation GENERAL_ICONS = new ResourceLocation("quark", "textures/gui/general_icons.png");
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final String[] VARIANT_WOOD_TYPES = new String[]{"spruce", "birch", "jungle", "acacia", "dark_oak"};
    public static final String[] ALL_WOOD_TYPES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
    private static int progress;

    public static void addToLootTable(LootTable table, LootEntry entry) {
        List pools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
        if (pools == null) {
            return;
        }
        LootPool pool = (LootPool)pools.get(0);
        List list = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
        if (list == null) {
            return;
        }
        list.add(entry);
    }

    public static void damageStack(PlayerEntity player, Hand hand, ItemStack stack, int dmg) {
        stack.func_222118_a(dmg, (LivingEntity)player, p -> p.func_213334_d(hand));
    }

    public static <T, V> void editFinalField(Class<T> clazz, String fieldName, Object obj, V value) {
        Field f = ObfuscationReflectionHelper.findField(clazz, (String)fieldName);
        MiscUtil.editFinalField(f, obj, value);
    }

    public static <T> void editFinalField(Field f, Object obj, T value) {
        try {
            f.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(obj, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initializeEnchantmentList(Iterable<String> enchantNames, List<Enchantment> enchants) {
        enchants.clear();
        for (String s : enchantNames) {
            ResourceLocation r = new ResourceLocation(s);
            Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(r);
            if (e == null) continue;
            enchants.add(e);
        }
    }

    public static Vec2f getMinecraftAngles(Vec3d direction) {
        direction = direction.func_72432_b();
        double pitch = Math.asin(direction.field_72448_b);
        double yaw = Math.asin(direction.field_72450_a / Math.cos(pitch));
        return new Vec2f((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static boolean isEntityInsideOpaqueBlock(Entity entity) {
        BlockPos pos = entity.func_180425_c();
        return !entity.field_70145_X && entity.field_70170_p.func_180495_p(pos).func_215696_m((IBlockReader)entity.field_70170_p, pos);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeystroke(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        String[] ids = new String[]{"FCYE87P5L0", "mybsDDymrsc", "6a4BWpBJppI", "thpTOAS1Vgg", "ZNcBZM5SvbY", "_qJEoSa3Ie0", "RWeyOyY_puQ", "VBbeuXW8Nko", "LIDe-yTxda0", "BVVfMFS3mgc", "m5qwcYL8a0o", "UkY8HvgvBJ8", "4K4b9Z9lSwc", "tyInv6RWL0Q", "tIWpr3tHzII", "AFJPFfnzZ7w", "846cjX0ZTrk", "XEOCbFJjRw0", "8Vto_qUIjcA"};
        int[] keys = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
        if (event.getGui() instanceof MainMenuScreen) {
            if (keys[progress] == event.getKeyCode()) {
                if (++progress >= keys.length) {
                    progress = 0;
                    Util.func_110647_a().func_195640_a("https://www.youtube.com/watch?v=" + ids[new Random().nextInt(ids.length)]);
                }
            } else {
                progress = 0;
            }
        }
    }
}

