/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.tile;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.DispenserContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import vazkii.quark.automation.block.FeedingTroughBlock;
import vazkii.quark.automation.module.FeedingTroughModule;
import vazkii.quark.base.handler.MiscUtil;

public class FeedingTroughTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity {
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.randomUUID(), "[FeedingTrough]");
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private FakePlayer foodHolder = null;
    private int cooldown = 0;
    private long internalRng = 0L;

    protected FeedingTroughTileEntity(TileEntityType<? extends FeedingTroughTileEntity> type) {
        super(type);
    }

    public FeedingTroughTileEntity() {
        this(FeedingTroughModule.tileEntityType);
    }

    public FakePlayer getFoodHolder(TemptGoal goal) {
        if (this.foodHolder == null && this.field_145850_b instanceof ServerWorld) {
            this.foodHolder = new FakePlayer((ServerWorld)this.field_145850_b, DUMMY_PROFILE);
        }
        AnimalEntity entity = (AnimalEntity)goal.field_75284_a;
        if (this.foodHolder != null) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (!goal.func_188508_a(stack) || !entity.func_70877_b(stack)) continue;
                this.foodHolder.field_71071_by.field_70462_a.set(this.foodHolder.field_71071_by.field_70461_c, (Object)stack);
                Vec3d position = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
                Vec3d direction = goal.field_75284_a.func_174791_d().func_178788_d(position).func_72432_b();
                Vec2f angles = MiscUtil.getMinecraftAngles(direction);
                Vec3d shift = direction.func_186678_a(-0.5 / Math.max(Math.abs(direction.field_72450_a), Math.max(Math.abs(direction.field_72448_b), Math.abs(direction.field_72449_c))));
                Vec3d truePos = position.func_178787_e(shift);
                this.foodHolder.func_70012_b(truePos.field_72450_a, truePos.field_72448_b, truePos.field_72449_c, angles.field_189982_i, angles.field_189983_j);
                return this.foodHolder;
            }
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                this.cooldown = FeedingTroughModule.cooldown;
                List animals = this.field_145850_b.func_217357_a(AnimalEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(1.5, 0.0, 1.5).func_191195_a(0.0, 0.75, 0.0));
                for (AnimalEntity creature : animals) {
                    if (!creature.func_204701_dC() || creature.func_70874_b() != 0) continue;
                    for (int i = 0; i < this.func_70302_i_(); ++i) {
                        List animalsAround;
                        ItemStack stack = this.func_70301_a(i);
                        if (!creature.func_70877_b(stack)) continue;
                        creature.func_184185_a(creature.func_213353_d(stack), 0.5f + 0.5f * (float)this.field_145850_b.field_73012_v.nextInt(2), (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                        this.addItemParticles((Entity)creature, stack, 16);
                        if (this.getSpecialRand().nextDouble() < FeedingTroughModule.loveChance && (animalsAround = this.field_145850_b.func_217357_a(AnimalEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(FeedingTroughModule.range))).size() <= FeedingTroughModule.maxAnimals) {
                            creature.func_146082_f(null);
                        }
                        stack.func_190918_g(1);
                        this.func_70296_d();
                        return;
                    }
                }
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        BlockState state = this.func_195044_w();
        if (this.field_145850_b != null && state.func_177230_c() instanceof FeedingTroughBlock) {
            boolean shouldBeFull;
            boolean full = (Boolean)state.func_177229_b((IProperty)FeedingTroughBlock.FULL);
            boolean bl = shouldBeFull = !this.func_191420_l();
            if (full != shouldBeFull) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(shouldBeFull)), 2);
            }
        }
    }

    private void addItemParticles(Entity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3d direction = new Vec3d(((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            direction = direction.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            direction = direction.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            double yVelocity = (double)(-entity.field_70170_p.field_73012_v.nextFloat()) * 0.6 - 0.3;
            Vec3d position = new Vec3d(((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * 0.3, yVelocity, 0.6);
            position = position.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            position = position.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            position = position.func_72441_c(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
            if (this.field_145850_b instanceof ServerWorld) {
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), position.field_72450_a, position.field_72448_b, position.field_72449_c, 1, direction.field_72450_a, direction.field_72448_b + 0.05, direction.field_72449_c, 0.0);
                continue;
            }
            if (this.field_145850_b == null) continue;
            this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), position.field_72450_a, position.field_72448_b, position.field_72449_c, direction.field_72450_a, direction.field_72448_b + 0.05, direction.field_72449_c);
        }
    }

    private Random getSpecialRand() {
        Random specialRand = new Random(this.internalRng);
        this.internalRng = specialRand.nextLong();
        return specialRand;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("quark.container.feeding_trough", new Object[0]);
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.cooldown = nbt.func_74762_e("Cooldown");
        this.internalRng = nbt.func_74763_f("rng");
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(nbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Cooldown", this.cooldown);
        nbt.func_74772_a("rng", this.internalRng);
        if (!this.func_184282_c(nbt)) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks);
        }
        return nbt;
    }

    @Nonnull
    protected NonNullList<ItemStack> func_190576_q() {
        return this.stacks;
    }

    protected void func_199721_a(@Nonnull NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory playerInventory) {
        return new DispenserContainer(id, playerInventory, (IInventory)this);
    }
}

