/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.Module;

public class IronChainBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape SHAPE = IronChainBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final EnumProperty<ChainType> TYPE = EnumProperty.func_177709_a((String)"type", ChainType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public IronChainBlock(Module module) {
        super("iron_chain", module, ItemGroup.field_78029_e, Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(0.5f).func_200947_a(SoundType.field_222475_v));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)ChainType.MIDDLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return IronChainBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177984_a(), (Direction)Direction.DOWN);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a(TYPE, (Comparable)((Object)this.getChainType(context.func_195991_k(), context.func_195995_a())))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)worldIn.func_180495_p(pos)));
            IronChainBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            ChainType curr = (ChainType)((Object)state.func_177229_b(TYPE));
            ChainType target = this.getChainType(worldIn, pos);
            if (target != curr) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)target)));
            }
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    public ChainType getChainType(World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        BlockState state = world.func_180495_p(up);
        if (IronChainBlock.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)up, (Direction)Direction.DOWN)) {
            return ChainType.TOP;
        }
        BlockPos down = pos.func_177977_b();
        if (world.func_175623_d(down) || world.func_180495_p(down).func_177230_c() == Blocks.field_150355_j) {
            return ChainType.BOTTOM;
        }
        return ChainType.MIDDLE;
    }

    public static enum ChainType implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

