/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.LeavesBlockToBreak;
import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="falling_tree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static Collection<LeavesBlockToBreak> leavesToRemove = new ConcurrentLinkedQueue<LeavesBlockToBreak>();

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getWorld().func_201670_d() && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer())) {
            TreeHandler.getTree(event.getWorld(), event.getPos()).ifPresent(tree -> {
                if ((Integer)Config.COMMON.maxTreeSize.get() >= tree.getLogCount()) {
                    if (TreeHandler.destroy(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                        event.setCanceled(true);
                    }
                } else {
                    event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), Config.COMMON.maxTreeSize.get()}));
                }
            });
        }
    }

    private static boolean isPlayerInRightState(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d && !FallingTree.isDevBuild()) {
            return false;
        }
        if (((Boolean)Config.COMMON.reverseSneaking.get()).booleanValue() != player.func_70093_af()) {
            return false;
        }
        return TreeHandler.canPlayerBreakTree(player);
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (((Boolean)Config.COMMON.breakLeaves.get()).booleanValue() && !event.getWorld().func_201670_d()) {
            BlockPos eventPos;
            World world = (World)event.getWorld();
            BlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockReader)world, eventPos = event.getPos())) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.func_175667_e(neighborPos) || !BlockTags.field_206952_E.func_199685_a_((Object)(neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c())) continue;
                    leavesToRemove.add(new LeavesBlockToBreak(world, neighborPos));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeavesBlockToBreak> iterator = leavesToRemove.iterator();
            while (iterator.hasNext()) {
                LeavesBlockToBreak leavesBlockToBreak = iterator.next();
                iterator.remove();
                Optional.ofNullable(leavesBlockToBreak.getWorld()).ifPresent(world -> {
                    BlockState state;
                    if (world.func_175667_e(leavesBlockToBreak.getBlockPos()) && BlockTags.field_206952_E.func_199685_a_((Object)(state = world.func_180495_p(leavesBlockToBreak.getBlockPos())).func_177230_c())) {
                        state.func_196940_a(world, leavesBlockToBreak.getBlockPos(), world.func_201674_k());
                        state.func_196944_b(world, leavesBlockToBreak.getBlockPos(), world.func_201674_k());
                    }
                });
            }
        }
    }
}

