/*
 * Decompiled with CFR 0.152.
 */
package com.kowloon.moredogs.common;

import com.google.common.collect.Maps;
import com.kowloon.moredogs.common.Dog;
import com.kowloon.moredogs.common.DogBegGoal;
import com.kowloon.moredogs.core.MoreDogsRegistries;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Pug
extends Dog {
    EntityType<? extends Pug> child;
    private static final DataParameter<Integer> PUG_TYPE = EntityDataManager.func_187226_a(Pug.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Map<Integer, ResourceLocation> coatMap = (Map)Util.func_200696_a((Object)Maps.newHashMap(), coats -> {
        coats.put(0, MoreDogsRegistries.location("textures/entity/pug/pug.png"));
        coats.put(1, MoreDogsRegistries.location("textures/entity/pug/pug_1.png"));
    });
    public static final Map<Integer, ResourceLocation> angryCoatMap = (Map)Util.func_200696_a((Object)Maps.newHashMap(), coats -> {
        coats.put(0, MoreDogsRegistries.location("textures/entity/pug/pug_angry.png"));
        coats.put(1, MoreDogsRegistries.location("textures/entity/pug/pug_1_angry.png"));
    });
    public static final Predicate<LivingEntity> field_213441_bD = p_213440_0_ -> {
        EntityType entitytype = p_213440_0_.func_200600_R();
        return entitytype == EntityType.field_200737_ac || entitytype == EntityType.field_200736_ab || entitytype == EntityType.field_220356_B;
    };

    public Pug(EntityType<? extends Pug> type, World worldIn) {
        super(type, worldIn);
        this.child = type;
        this.func_70903_f(false);
    }

    private void setDogCoat(int coat) {
        if (coat < 0 || coat > 1) {
            coat = this.field_70146_Z.nextInt(2);
        }
        this.field_70180_af.func_187227_b(PUG_TYPE, (Object)coat);
    }

    public int getDogCoat() {
        return (Integer)this.field_70180_af.func_187225_a(PUG_TYPE);
    }

    public ResourceLocation getTexture() {
        if (this.isAngry()) {
            return angryCoatMap.get(this.getDogCoat());
        }
        return coatMap.get(this.getDogCoat());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setDogCoat(this.field_70146_Z.nextInt(2));
        return spawnDataIn;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUG_TYPE, (Object)this.field_70146_Z.nextInt(2));
    }

    @Override
    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.5, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 0.5, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (Goal)new DogBegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, field_213441_bD));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public Pug createChild(AgeableEntity ageable) {
        Pug child = new Pug(this.child, this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        child.setDogCoat(this.getDogCoat());
        return child;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 0.0f;
        }
        return this.func_70909_n() ? (0.1818f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(healthData)).floatValue()) * 0.02f) * (float)Math.PI : -0.2618f;
    }
}

