/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.ModData;
import al132.alib.client.CapabilityDisplayWrapper;
import al132.alib.client.CapabilityEnergyDisplayWrapper;
import al132.alib.client.CapabilityFluidDisplayWrapper;
import al132.alib.container.ABaseContainer;
import al132.alib.tiles.GuiTile;
import al132.alib.utils.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ABaseScreen<T extends ABaseContainer>
extends ContainerScreen<T> {
    protected ResourceLocation GUI;
    T screenContainer;
    protected List<CapabilityDisplayWrapper> displayData = new ArrayList<CapabilityDisplayWrapper>();
    ResourceLocation powerBarTexture;

    public ABaseScreen(ModData data, T screenContainer, PlayerInventory inv, ITextComponent name, String path) {
        super(screenContainer, inv, name);
        this.powerBarTexture = new ResourceLocation(data.MODID, "textures/gui/template.png");
        this.screenContainer = screenContainer;
        this.field_146999_f = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getWidth();
        this.field_147000_g = ((GuiTile)((Object)((ABaseContainer)((Object)screenContainer)).tile)).getHeight();
        this.GUI = new ResourceLocation(data.MODID, path);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.width - this.field_146999_f) / 2;
        int relY = (this.height - this.field_147000_g) / 2;
        this.blit(relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.displayData.forEach(data -> {
            if (data instanceof CapabilityEnergyDisplayWrapper) {
                this.drawPowerBar((CapabilityEnergyDisplayWrapper)data, this.powerBarTexture, 0, 0);
            } else if (data instanceof CapabilityFluidDisplayWrapper) {
                this.drawFluidTank((CapabilityFluidDisplayWrapper)data, relX + data.x, relY + data.y);
            }
        });
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String displayName = ((ABaseContainer)((Object)this.screenContainer)).tile.func_145748_c_().getString();
        this.drawString(this.font, displayName, this.field_146999_f / 2 - this.font.func_78256_a(displayName) / 2, -10, Color.WHITE.getRGB());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.displayData.stream().filter(data -> mouseX >= data.x + x && mouseX <= data.x + x + data.width && mouseY >= data.y + y && mouseY <= data.y + y + data.height).forEach(it -> this.renderTooltip(it.toStringList(), mouseX, mouseY, this.font));
    }

    public int getBarScaled(int pixels, int count, int max) {
        if (count > 0 && max > 0) {
            return count * pixels / max;
        }
        return 0;
    }

    public void drawPowerBar(CapabilityEnergyDisplayWrapper storage, ResourceLocation texture, int textureX, int textureY) {
        if (storage.getStored() > 0) {
            int i = storage.x + (this.width - this.field_146999_f) / 2;
            int j = storage.y + (this.height - this.field_147000_g) / 2;
            int k = this.getBarScaled(storage.height, storage.getStored(), storage.getCapacity());
            this.minecraft.field_71446_o.func_110577_a(texture);
            this.blit(i, j + storage.height - k, textureX, textureY, storage.width, k);
            this.minecraft.field_71446_o.func_110577_a(this.GUI);
        }
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j) {
        this.drawFluidTank(wrapper, i, j, 16, 60);
    }

    public void drawFluidTank(CapabilityFluidDisplayWrapper wrapper, int i, int j, int width, int height) {
        if (wrapper.getStored() > 5) {
            RenderUtils.bindBlockTexture();
            RenderUtils.renderGuiTank(wrapper.fluid.get().getFluidInTank(0), wrapper.getCapacity(), wrapper.getStored(), i, j, this.blitOffset, width, height);
        }
    }

    public void bindWidgets() {
        this.minecraft.field_71446_o.func_110577_a(new ResourceLocation("alib", "textures/gui/widgets.png"));
    }

    public void drawRightArrow(int x, int y, int width) {
        int height = 9;
        this.bindWidgets();
        this.blit(x, y, 0, 120, width, height);
    }

    public void drawDownArrow(int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.blit(x, y, 9, 129, width, height);
    }

    public void drawUpArrow(int x, int y, int height) {
        int width = 9;
        this.bindWidgets();
        this.blit(x, y, 0, 129, width, height);
    }
}

