/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.render;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public class ScalingTextRender {
    protected final Supplier<FontRenderer> fontRenderSupplier;
    protected Supplier<String> textSupplier;
    private String text;
    private int textWidth;
    protected int color;
    protected boolean shadow;
    protected float scale;

    public ScalingTextRender(Supplier<FontRenderer> fontRenderSupplier, Supplier<String> textSupplier) {
        this.fontRenderSupplier = fontRenderSupplier;
        this.textSupplier = textSupplier;
        this.scale = 1.0f;
    }

    public void setTextSupplier(Supplier<String> textSupplier) {
        Objects.requireNonNull(textSupplier);
        this.textSupplier = textSupplier;
    }

    public Supplier<String> getTextSupplier() {
        return this.textSupplier;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public float getTextWidth() {
        if (this.textWidth == 0) {
            this.setText(this.textSupplier.get());
        }
        return (float)this.textWidth * this.scale;
    }

    private void setText(String newText) {
        if (newText != null && !newText.equals(this.text) || newText == null) {
            this.text = newText;
            this.textWidth = this.fontRenderSupplier.get().func_78256_a(newText);
            this.updatedText();
        }
    }

    protected void updatedText() {
    }

    public void draw(float x, float y) {
        this.setText(this.textSupplier.get());
        this.renderFont(x, y);
    }

    protected void renderFont(float x, float y) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)0.0f);
        if (this.shadow) {
            this.fontRenderSupplier.get().func_175063_a(this.text, 0.0f, 0.0f, this.color);
        } else {
            this.fontRenderSupplier.get().func_211126_b(this.text, 0.0f, 0.0f, this.color);
        }
        GL11.glPopMatrix();
    }
}

