/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.energy;

import info.u_team.u_team_core.api.sync.BufferReferenceHolder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class BasicEnergyStorage
extends EnergyStorage
implements INBTSerializable<CompoundNBT> {
    public BasicEnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public BasicEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public BasicEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public BasicEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public int getEnergy() {
        return super.getEnergyStored();
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void addEnergy(int energy) {
        this.energy += energy;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getMaxEnergyStored();
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("energy", this.getEnergyStored());
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.setEnergy(compound.func_74762_e("energy"));
    }

    public BufferReferenceHolder createSyncHandler() {
        return BufferReferenceHolder.createIntHolder(this::getEnergy, this::setEnergy);
    }
}

