/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.TagUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class CommonRecipesProvider
extends CommonProvider {
    protected CommonRecipesProvider(GenerationData data) {
        super(data);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.registerRecipes(recipe -> this.generateRecipe(cache, (IFinishedRecipe)recipe, false));
        this.registerDefaultAdvancementsRecipes(recipe -> this.generateRecipe(cache, (IFinishedRecipe)recipe, true));
    }

    public String func_200397_b() {
        return "Recipes";
    }

    private void generateRecipe(DirectoryCache cache, IFinishedRecipe recipe, boolean vanillaAdvancement) {
        try {
            ResourceLocation recipeLocation = recipe.func_200442_b();
            CommonRecipesProvider.write(cache, (JsonElement)recipe.func_200441_a(), this.resolveData(recipeLocation).resolve("recipes").resolve(recipe.func_200442_b().func_110623_a() + ".json"));
            if (recipe.func_200440_c() != null) {
                Path advancementPath;
                if (vanillaAdvancement) {
                    ResourceLocation advancementLocation = recipe.func_200443_d();
                    advancementPath = this.resolveData(advancementLocation).resolve("advancements").resolve(advancementLocation.func_110623_a() + ".json");
                } else {
                    advancementPath = this.resolveData(recipeLocation).resolve("advancements").resolve("recipes").resolve(recipeLocation.func_110623_a() + ".json");
                }
                CommonRecipesProvider.write(cache, (JsonElement)recipe.func_200440_c(), advancementPath);
            }
        }
        catch (IOException ex) {
            LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
        }
    }

    protected abstract void registerRecipes(Consumer<IFinishedRecipe> var1);

    protected void registerDefaultAdvancementsRecipes(Consumer<IFinishedRecipe> consumer) {
    }

    protected InventoryChangeTrigger.Instance hasItem(Tag<Item> tag) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(IItemProvider item) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    public static Ingredient getIngredientOfTag(Tag<Item> tag) {
        return TagUtil.getSerializableIngredientOfTag(tag);
    }
}

