/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.data.CommonTagsProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class CommonItemTagsProvider
extends CommonTagsProvider<Item> {
    protected CommonItemTagsProvider(GenerationData data) {
        super(data, ForgeRegistries.ITEMS);
    }

    @Override
    protected Path makePath(ResourceLocation location) {
        return this.resolveData(location).resolve("tags").resolve("items").resolve(location.func_110623_a() + ".json");
    }

    @Override
    protected void setCollection(TagCollection<Item> collection) {
        ItemTags.func_199902_a(collection);
    }

    public String func_200397_b() {
        return "Item-Tags";
    }

    protected void copy(Tag<Block> from, Tag<Item> to) {
        from.func_200570_b().forEach(entry -> this.getBuilder(to).func_200575_a(this.copyEntry((Tag.ITagEntry<Block>)entry)));
    }

    private Tag.ITagEntry<Item> copyEntry(Tag.ITagEntry<Block> entry) {
        if (entry instanceof Tag.TagEntry) {
            return new Tag.TagEntry(((Tag.TagEntry)entry).func_200577_a());
        }
        if (entry instanceof Tag.ListEntry) {
            ArrayList list = Lists.newArrayList();
            for (Block block : ((Tag.ListEntry)entry).func_200578_a()) {
                Item item = block.func_199767_j();
                if (item == Items.field_190931_a) {
                    LOGGER.warn("Itemless block copied to item tag: {}", (Object)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block));
                    continue;
                }
                list.add(item);
            }
            return new Tag.ListEntry((Collection)list);
        }
        throw new UnsupportedOperationException("Unknown tag entry " + entry);
    }
}

