/*
 * Decompiled with CFR 0.152.
 */
package xaero.minimap;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.message.MessageWaypoint;
import xaero.common.api.spigot.message.in.InMessageWaypointConsumer;
import xaero.common.api.spigot.message.in.InMessageWaypointDecoder;
import xaero.common.api.spigot.message.in.InMessageWaypointEncoder;
import xaero.common.api.spigot.message.out.OutMessageHandshake;
import xaero.common.api.spigot.message.out.OutMessageWaypoint;
import xaero.common.api.spigot.message.out.OutMessageWaypointDecoder;
import xaero.common.api.spigot.message.out.OutMessageWaypointEncoder;
import xaero.common.controls.ControlsHandler;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.events.FMLEventHandler;
import xaero.common.events.ForgeEventHandler;
import xaero.common.events.ModEvents;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.WaypointSharingHandler;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.minimap.controls.MinimapControlsHandler;
import xaero.minimap.gui.MinimapGuiHelper;
import xaero.minimap.interfaces.MinimapInterfaceLoader;
import xaero.patreon.Patreon4;
import xaero.patreon.PatreonMod2;

@Mod(value="xaerominimap")
public class XaeroMinimap
implements IXaeroMinimap {
    private static final boolean ENABLED = true;
    public static XaeroMinimap instance;
    private final Logger LOGGER = LogManager.getLogger();
    private static final String versionID = "1.14.4_20.7.1";
    private int newestUpdateID;
    private boolean isOutdated = true;
    private String fileLayoutID = "1.14.4_20.7.1".endsWith("fair") ? "minimapfair" : "minimap";
    private String latestVersion;
    private static final File old_optionsFile;
    private static final File oldConfigFile;
    private ModSettings settings;
    private String message = "";
    private ControlsHandler controls;
    private ForgeEventHandler events;
    private FMLEventHandler fmlEvents;
    private InterfaceManager interfaces;
    private InterfaceRenderer interfaceRenderer;
    private GuiHelper guiHelper;
    private SupportMods supportMods;
    private WaypointsManager waypointsManager;
    private WaypointSharingHandler waypointSharing;
    private FieldValidatorHolder fieldValidators;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private SimpleChannel network;

    public XaeroMinimap() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void loadClient(FMLClientSetupEvent event) {
        try {
            Path waypointTempToAddFolder;
            this.LOGGER.info("Loading Xaero's Minimap - Stage 1/2");
            ModOptions.init(this);
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById("xaerominimap").getFile();
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                this.modJAR = modFile.getFilePath().toFile();
            }
            Path gameDir = FMLPaths.GAMEDIR.get();
            Path config = FMLPaths.CONFIGDIR.get();
            this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
            Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
            Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
            Path wrongWaypointsFolder4 = new File(config.toFile().getCanonicalPath()).toPath().getParent().resolve("XaeroWaypoints");
            Path wrongWaypointsFolder5 = config.getParent().resolve("XaeroWaypoints");
            this.waypointsFolder = gameDir.resolve("XaeroWaypoints").toFile();
            if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
                Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder4.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder4, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder5.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder5, this.waypointsFolder.toPath(), new CopyOption[0]);
            }
            this.configFile = config.resolve("xaerominimap.txt").toFile();
            if (oldConfigFile.exists() && !this.configFile.getAbsolutePath().equals(oldConfigFile.getAbsolutePath())) {
                Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (Files.exists(waypointTempToAddFolder = this.waypointsFolder.toPath().resolve("temp_to_add"), new LinkOption[0])) {
                ModSettings.copyTempFilesBack(waypointTempToAddFolder);
            }
            Patreon4.checkPatreon();
            Patreon4.rendersCapes = this.fileLayoutID;
            this.waypointsManager = new WaypointsManager(this);
            this.waypointSharing = new WaypointSharingHandler(this);
            this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator());
            this.interfaceRenderer = new InterfaceRenderer(this);
            this.widgetScreenHandler = new WidgetScreenHandler();
            this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
            ModEvents modEvents = new ModEvents(this);
            modEvents.addListeners(FMLJavaModLoadingContext.get().getModEventBus());
            DeferredWorkQueue.runLater(this::loadLater);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadLater() {
        this.LOGGER.info("Loading Xaero's Minimap - Stage 2/2");
        try {
            MinimapInterfaceLoader interfaceLoader = new MinimapInterfaceLoader();
            this.interfaces = new InterfaceManager(this, interfaceLoader);
            this.settings = new ModSettings(this);
            this.controls = new MinimapControlsHandler(this);
            if (old_optionsFile.exists() && !this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
                this.waypointsFile.getParentFile().mkdirs();
                Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            this.settings.loadSettings();
            this.events = new ForgeEventHandler(this);
            KeyEventHandler keyEventHandler = new KeyEventHandler();
            this.fmlEvents = new FMLEventHandler(this, keyEventHandler);
            Internet.checkModVersion(this);
            if (Patreon4.patronPledge >= 5 && this.isOutdated) {
                this.getPatreon().modJar = this.modJAR;
                this.getPatreon().currentVersion = versionID;
                this.getPatreon().latestVersion = this.latestVersion;
                Patreon4.addOutdatedMod(this.getPatreon());
            }
            MinecraftForge.EVENT_BUS.register((Object)this.events);
            MinecraftForge.EVENT_BUS.register((Object)this.fmlEvents);
            this.guiHelper = new MinimapGuiHelper(this);
            this.supportMods = new SupportMods(this);
            this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("xaerominimap", "spigot_api"), () -> "1.0", s -> true, s -> true);
            this.network.registerMessage(0, MessageWaypoint.class, (BiConsumer)new InMessageWaypointEncoder(), (Function)new InMessageWaypointDecoder(), (BiConsumer)new InMessageWaypointConsumer());
            this.network.registerMessage(1, OutMessageWaypoint.class, new OutMessageWaypointEncoder(), new OutMessageWaypointDecoder(), (a, b) -> {});
            this.network.registerMessage(2, OutMessageHandshake.class, new OutMessageWaypointEncoder(), new OutMessageWaypointDecoder(), (a, b) -> {});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions/Minimap.txt";
    }

    @Override
    public String getUpdateLink() {
        return "http://goo.gl/DsWDI5";
    }

    @Override
    public SimpleChannel getNetwork() {
        return this.network;
    }

    @Override
    public File getOldOptionsFile() {
        return old_optionsFile;
    }

    @Override
    public File getOldConfigFile() {
        return oldConfigFile;
    }

    @Override
    public String getFileLayoutID() {
        return this.fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() {
        this.settings = new ModSettings(this);
    }

    @Override
    public ControlsHandler getControls() {
        return this.controls;
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod2 getPatreon() {
        return Patreon4.mods.get(this.fileLayoutID);
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return MinimapControlsHandler.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public WaypointsManager getWaypointsManager() {
        return this.waypointsManager;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public WaypointSharingHandler getWaypointSharing() {
        return this.waypointSharing;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    static {
        old_optionsFile = new File("xaerominimap.txt");
        oldConfigFile = new File("config/xaerominimap.txt");
    }
}

