/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import com.mojang.realmsclient.dto.RealmsServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class WaypointsManager {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    private WaypointSet waypoints = null;
    private List<Waypoint> serverWaypoints = null;
    public static final Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = new Hashtable();
    private String containerID = null;
    private String containerIDIgnoreCaseCache;
    private String customContainerID = null;
    private String worldID = null;
    private String customWorldID = null;
    private BlockPos currentSpawn;
    private String currentSpawnRootContainerId;
    private RealmsServer latestRealm;
    public long setChanged;
    public boolean renderAllSets;

    public WaypointsManager(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.mc = Minecraft.func_71410_x();
    }

    public boolean divideBy8(String worldContainerID) {
        return worldContainerID != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p() == DimensionType.field_223228_b_ && worldContainerID.endsWith(this.getDimensionDirectoryName(0));
    }

    public String getDimensionDirectoryName(int dim) {
        return "dim%" + dim;
    }

    public static ResourceLocation getDimensionKey(DimensionType dt) {
        ResourceLocation dimKey = DimensionType.func_212678_a((DimensionType)dt);
        if (dimKey == null) {
            dimKey = dt.getRegistryName();
        }
        return dimKey;
    }

    public DimensionType findDimensionType(String validatedName) {
        Iterable allDimensionTypes = DimensionType.func_212681_b();
        for (DimensionType dt : allDimensionTypes) {
            if (!validatedName.equals(WaypointsManager.getDimensionKey(dt).func_110623_a().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dt;
        }
        return null;
    }

    public Integer getDimensionForDirectoryName(String dirName) {
        int dimId;
        String dimIdPart = dirName.substring(4);
        if (!dimIdPart.matches("-{0,1}[0-9]+")) {
            return null;
        }
        try {
            dimId = Integer.parseInt(dimIdPart);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return dimId;
    }

    private String getContainer(World world) {
        String potentialContainerID;
        String dim = this.getDimensionDirectoryName(world.func_201675_m().func_186058_p().func_186068_a());
        if (this.mc.func_71401_C() != null) {
            potentialContainerID = this.mc.func_71401_C().func_71270_I().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%") + "/" + dim;
        } else if (this.mc.func_147104_D() != null) {
            String serverIP;
            String string = serverIP = this.modMain.getSettings().differentiateByServerAddress ? this.mc.func_147104_D().field_78845_b : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            potentialContainerID = this.mc.func_147104_D() != null && ServerWaypointStorage.autoWorldUID != null ? ServerWaypointStorage.getAutoContainer() : "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%") + "/" + dim;
        } else {
            potentialContainerID = this.mc.func_181540_al() && this.latestRealm != null ? "Realms_" + this.latestRealm.ownerUUID + "." + this.latestRealm.id + "/" + dim : "Unknown";
        }
        this.containerIDIgnoreCaseCache = potentialContainerID = this.ignoreContainerCase(potentialContainerID, this.containerIDIgnoreCaseCache);
        return potentialContainerID;
    }

    public String ignoreContainerCase(String potentialContainerID, String current) {
        if (potentialContainerID.equalsIgnoreCase(current)) {
            return current;
        }
        Set<Map.Entry<String, WaypointWorldContainer>> entries = this.waypointMap.entrySet();
        for (Map.Entry<String, WaypointWorldContainer> e : entries) {
            String containerSearch = e.getValue().getEqualIgnoreCaseSub(potentialContainerID);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerID;
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerID() + "_" + this.getCurrentWorldID();
    }

    private String getWorld(World world) {
        if (this.mc.func_71401_C() != null) {
            return "waypoints";
        }
        if (this.currentSpawn != null && this.currentSpawnRootContainerId.equals(this.getAutoRootContainerID())) {
            if (this.mc.func_147104_D() != null && ServerWaypointStorage.autoWorldUID != null) {
                return ServerWaypointStorage.getAutoWorld();
            }
            String actualMultiworldId = "mw" + (this.currentSpawn.func_177958_n() >> 6) + "," + (this.currentSpawn.func_177956_o() >> 6) + "," + (this.currentSpawn.func_177952_p() >> 6);
            WaypointWorldRootContainer rootContainer = this.getWorldContainer(this.containerID).getRootContainer();
            if (!rootContainer.isUsingMultiworldDetection()) {
                String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                if (defaultMultiworldId == null) {
                    rootContainer.setDefaultMultiworldId(actualMultiworldId);
                    rootContainer.saveConfig();
                    return actualMultiworldId;
                }
                return defaultMultiworldId;
            }
            return actualMultiworldId;
        }
        return null;
    }

    public String getCurrentContainerID() {
        if (this.customContainerID == null) {
            return this.containerID;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID() {
        if (this.customWorldID == null) {
            return this.worldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld() {
        return this.getWorld(this.getCurrentContainerID(), this.getCurrentWorldID());
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getCurrentOriginContainerID() {
        if (this.getCurrentContainerID() == null) {
            return null;
        }
        return this.getCurrentContainerID().split("/")[0];
    }

    public String getAutoRootContainerID() {
        if (this.containerID == null) {
            return null;
        }
        return this.containerID.split("/")[0];
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        if (container == null) {
            return null;
        }
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldRootContainer(this.modMain, subs[i]);
                this.waypointMap.put(subs[i], container);
                WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)container;
                if (rootContainer.configLoaded) continue;
                rootContainer.loadConfig();
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public void removeContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return;
                }
                if (i != subs.length - 1) continue;
                this.waypointMap.remove(subs[i]);
                return;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    container.deleteSubContainer(subs[i]);
                    return;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return;
        }
    }

    public boolean containerExists(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return false;
                }
                if (i != subs.length - 1) continue;
                return true;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    return true;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return false;
        }
        return false;
    }

    public void updateWorldIds() {
        String oldContainerID = this.containerID;
        String oldWorldID = this.worldID;
        this.containerID = this.getContainer((World)this.mc.field_71441_e);
        WaypointWorldContainer wwc = null;
        String potentialWorldID = this.getWorld((World)this.mc.field_71441_e);
        if (potentialWorldID == null) {
            this.containerID = oldContainerID;
            this.worldID = oldWorldID;
        } else {
            wwc = this.getWorldContainer(this.containerID);
            this.worldID = wwc.applyPointer(potentialWorldID);
            if (this.containerID != null && !this.containerID.equals(oldContainerID)) {
                if (oldWorldID != null && oldWorldID.startsWith("plugin")) {
                    WaypointWorldContainer oldContainer = this.getWorldContainer(oldContainerID);
                    ArrayList<WaypointWorld> worlds = new ArrayList<WaypointWorld>(oldContainer.worlds.values());
                    for (int i = 0; i < worlds.size(); ++i) {
                        worlds.get(i).getServerWaypoints().clear();
                    }
                }
                String rootContainerId = this.getAutoRootContainerID();
                WaypointWorldContainer rootContainer = this.getWorldContainer(rootContainerId);
                rootContainer.renameOldContainer(this.containerID);
            }
        }
        if (this.containerID != null && this.containerID.equals(oldContainerID) && this.worldID != null && !this.worldID.equals(oldWorldID) && this.modMain.getEvents().getDied() != -1L && System.currentTimeMillis() - this.modMain.getEvents().getDied() <= 1000L) {
            wwc.addPointer(this.worldID, oldWorldID);
            this.worldID = oldWorldID;
        }
    }

    public void updateWaypoints() {
        if (this.containerID != null && this.worldID != null) {
            this.addWorld(this.containerID, this.worldID);
            WaypointWorld world = this.getCurrentWorld();
            this.waypoints = world.getCurrentSet();
            this.serverWaypoints = !world.getServerWaypoints().isEmpty() ? new ArrayList<Waypoint>(world.getServerWaypoints().values()) : null;
        }
    }

    public void createDeathpoint(PlayerEntity p) {
        boolean disabled = false;
        if (this.waypoints == null) {
            return;
        }
        ArrayList<Waypoint> list = this.waypoints.getList();
        for (int i = 0; i < list.size(); ++i) {
            Waypoint w = (Waypoint)list.get(i);
            if (w.getType() != 1) continue;
            disabled = w.isDisabled();
            if (!this.modMain.getSettings().getDeathpoints() || !this.modMain.getSettings().getOldDeathpoints()) {
                list.remove(w);
                break;
            }
            w.setType(0);
            w.setName("gui.xaero_deathpoint_old");
            break;
        }
        boolean divideBy8 = this.divideBy8(this.getCurrentContainerID());
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor(p.field_70165_t) * (divideBy8 ? 8 : 1), OptimizedMath.myFloor(p.field_70163_u), OptimizedMath.myFloor(p.field_70161_v) * (divideBy8 ? 8 : 1), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            list.add(0, deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.getCurrentWorld());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createTemporaryWaypoints(int x, int y, int z) {
        if (this.modMain.getSettings().waypointsGUI() && this.waypoints != null) {
            boolean divideBy8 = this.divideBy8(this.getCurrentContainerID());
            Waypoint instant = new Waypoint(x *= divideBy8 ? 8 : 1, y, z *= divideBy8 ? 8 : 1, "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, true);
            this.waypoints.getList().add(0, instant);
            try {
                this.modMain.getSettings().saveWaypoints(this.getCurrentWorld());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, WaypointWorld displayedWorld) {
        return (this.modMain.getSettings().allowWrongWorldTeleportation || displayingTeleportableWorld) && displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, Screen screen) {
        boolean displayingTeleportableWorld = this.isWorldTeleportable(displayedWorld);
        if (selected != null && this.canTeleport(displayingTeleportableWorld, displayedWorld)) {
            this.mc.func_147108_a(null);
            String tpCommand = "";
            boolean reachableDimension = true;
            boolean crossDimension = false;
            if (this.modMain.getSettings().crossDimensionalTp && displayingTeleportableWorld && displayedWorld != this.getAutoWorld()) {
                if (!this.modMain.getSettings().mpCrossDimensionalTp && (this.getAutoContainerID().startsWith("Multiplayer_") || this.getAutoContainerID().startsWith("Realms_"))) {
                    this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_mp_cross_disabled", (Object[])new Object[0])));
                    return;
                }
                crossDimension = true;
                String[] containerKeySplit = displayedWorld.getContainer().getKey().split("/");
                if (containerKeySplit.length > 1) {
                    String dimensionKey = containerKeySplit[1];
                    if (!dimensionKey.startsWith("dim%")) {
                        this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("gui.xaero_visit_needed", new Object[0]));
                        return;
                    }
                    Integer dimensionId = this.getDimensionForDirectoryName(dimensionKey);
                    if (dimensionId != null) {
                        DimensionType dt = DimensionType.func_186069_a((int)dimensionId);
                        if (dt != null) {
                            this.setCustomContainerID(null);
                            this.setCustomWorldID(null);
                            this.updateWaypoints();
                            tpCommand = "execute in " + WaypointsManager.getDimensionKey(dt).toString() + " run ";
                        } else {
                            reachableDimension = false;
                        }
                    } else {
                        reachableDimension = false;
                    }
                } else {
                    reachableDimension = false;
                }
            }
            if (reachableDimension) {
                WaypointWorldRootContainer rootContainer;
                int x = selected.getX();
                int z = selected.getZ();
                if (!crossDimension && this.divideBy8(displayedWorld.getContainer().getKey())) {
                    x = Math.floorDiv(x, 8);
                    z = Math.floorDiv(z, 8);
                }
                String tpCommandPrefix = (rootContainer = displayedWorld.getContainer().getRootContainer()).isUsingDefaultTeleportCommand() || rootContainer.getTeleportCommand() == null ? this.modMain.getSettings().waypointTp : rootContainer.getTeleportCommand();
                tpCommand = !selected.isRotation() ? tpCommand + tpCommandPrefix + " " + x + " " + selected.getY() + " " + z : tpCommand + tpCommandPrefix + " " + x + " " + selected.getY() + " " + z + " " + selected.getYaw() + " ~";
                screen.sendMessage("/" + tpCommand, false);
            } else {
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("\u00a7c" + I18n.func_135052_a((String)"gui.xaero_unreachable_dimension", (Object[])new Object[0])));
            }
        }
    }

    public boolean isWorldTeleportable(WaypointWorld displayedWorld) {
        return displayedWorld.getContainer().getRootContainer().getKey().equals(this.getAutoRootContainerID()) && (this.modMain.getSettings().crossDimensionalTp && displayedWorld.getId().equals(this.getAutoWorldID()) || !this.modMain.getSettings().crossDimensionalTp && displayedWorld == this.getAutoWorld());
    }

    public WaypointSet getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(WaypointSet waypoints) {
        this.waypoints = waypoints;
    }

    public List<Waypoint> getServerWaypoints() {
        return this.serverWaypoints;
    }

    public HashMap<String, WaypointWorldContainer> getWaypointMap() {
        return this.waypointMap;
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    public void setLatestRealm(RealmsServer latestRealm) {
        this.latestRealm = latestRealm;
    }

    public void setCurrentSpawn(BlockPos currentSpawn) {
        String actualCurrentContainer = this.getContainer((World)this.mc.field_71441_e);
        this.currentSpawnRootContainerId = actualCurrentContainer.contains("/") ? actualCurrentContainer.split("/")[0] : actualCurrentContainer;
        this.currentSpawn = currentSpawn;
    }

    public String getCustomContainerID() {
        return this.customContainerID;
    }

    public void setCustomContainerID(String customContainerID) {
        this.customContainerID = customContainerID;
    }

    public String getCustomWorldID() {
        return this.customWorldID;
    }

    public void setCustomWorldID(String customWorldID) {
        this.customWorldID = customWorldID;
    }

    public static Hashtable<Integer, Waypoint> getCustomWaypoints(String modName) {
        Hashtable<Integer, Waypoint> wps = customWaypoints.get(modName);
        if (wps == null) {
            wps = new Hashtable();
            customWaypoints.put(modName, wps);
        }
        return wps;
    }
}

