/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.world.chunk.Chunk;

public class XaeroMinimapCore {
    public static Field chunkDirtyField = null;

    public static void ensureField() {
        if (chunkDirtyField == null) {
            try {
                chunkDirtyField = Chunk.class.getDeclaredField("xaero_chunkDirty");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_212866_a_(x, z);
                        if (chunk == null) continue;
                        chunkDirtyField.set(chunk, true);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SChunkDataPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SChangeBlockPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SMultiBlockChangePacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179844_a()[0].func_180090_a().func_177958_n() >> 4, packetIn.func_179844_a()[0].func_180090_a().func_177952_p() >> 4);
    }
}

