/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.api.spigot.message.in;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import xaero.common.api.spigot.ServerWaypoint;
import xaero.common.api.spigot.message.MessageWaypoint;

public class InMessageWaypointDecoder
implements Function<PacketBuffer, MessageWaypoint> {
    @Override
    public MessageWaypoint apply(PacketBuffer buf) {
        MessageWaypoint msg = new MessageWaypoint();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            msg.setWaypoint(null);
            msg.setPacketID(in.readChar());
            switch (msg.getPacketID()) {
                case 'A': {
                    msg.setWorldUID(in.readUTF());
                    int x = in.readInt();
                    int y = in.readInt();
                    int z = in.readInt();
                    String name = in.readUTF();
                    char symbol = in.readChar();
                    int color = in.read();
                    int ID = in.readInt();
                    boolean hasRotation = in.readBoolean();
                    short yaw = 0;
                    if (hasRotation) {
                        yaw = in.readShort();
                    }
                    msg.setWaypoint(new ServerWaypoint(msg.getWorldUID(), ID, x, y, z, name, Character.toString(symbol), color, hasRotation, yaw));
                    break;
                }
                case 'R': {
                    msg.setWaypointID(in.readInt());
                    break;
                }
                case 'W': {
                    msg.setWorldUID(in.readUTF());
                    msg.setWorldName(in.readUTF());
                }
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return msg;
    }
}

