/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntityRenderer<TileEntityDrawers> {
    private boolean[] renderAsBlock = new boolean[4];
    private ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer renderItem;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};

    public void render(TileEntityDrawers tile, double x, double y, double z, float partialTickTime, int destroyStage) {
        if (tile == null) {
            return;
        }
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(tile.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        Direction side = (Direction)state.func_177229_b((IProperty)BlockDrawers.field_185512_D);
        int ambLight = this.func_178459_a().func_217338_b(tile.func_174877_v().func_177972_a(side), 0);
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        if (tile.upgrades().hasIlluminationUpgrade()) {
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)Math.max(208, lu), (float)lv);
        } else {
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lu, (float)lv);
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean cache = mc.field_71474_y.field_74347_j;
        mc.field_71474_y.field_74347_j = true;
        if (!tile.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(tile, state, side, partialTickTime);
        }
        mc.field_71474_y.field_74347_j = cache;
        GlStateManager.enableLighting();
        GlStateManager.enableLight((int)0);
        GlStateManager.enableLight((int)1);
        GlStateManager.enableColorMaterial();
        GlStateManager.colorMaterial((int)1032, (int)5634);
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableNormalize();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private void renderFastItemSet(TileEntityDrawers tile, BlockState state, Direction side, float partialTickTime) {
        int i;
        int drawerCount = tile.getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.field_190927_a;
            IDrawer drawer = tile.getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, side, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, side, partialTickTime);
        }
        if (tile.getDrawerAttributes().isShowingQuantity()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            BlockPos blockPos = tile.func_174877_v().func_177963_a(0.5, 0.5, 0.5);
            double distance = Math.sqrt(blockPos.func_177951_i((Vec3i)player.func_180425_c()));
            float alpha = 1.0f;
            if (distance > 4.0) {
                alpha = Math.max(1.0f - (float)((distance - 4.0) / 6.0), 0.05f);
            }
            if (distance < 10.0) {
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    this.renderText(CountFormatter.format(this.func_147498_b(), tile.getDrawer(i2)), tile, state, i2, side, alpha);
                }
            }
        }
    }

    private void renderText(String text, TileEntityDrawers tile, BlockState state, int slot, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.countGeometry[slot];
        int textWidth = this.func_147498_b().func_78256_a(text);
        float x = (float)(labelGeometry.field_72340_a + labelGeometry.func_216364_b() / 2.0);
        float y = 16.0f - (float)labelGeometry.field_72338_b - (float)labelGeometry.func_216360_c();
        float z = (float)labelGeometry.field_72339_c * 0.0625f;
        GlStateManager.pushMatrix();
        this.alignRendering(side);
        this.moveRendering(0.125f, 0.125f, x, y, z);
        GlStateManager.disableLighting();
        GlStateManager.enablePolygonOffset();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.polygonOffset((float)-1.0f, (float)-20.0f);
        this.func_147498_b().func_211126_b(text, (float)(-textWidth / 2), 0.0f, (int)(255.0f * alpha) << 24 | 0xFF0000 | 0xFF00 | 0xFF);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private void renderFastItem(@Nonnull ItemStack itemStack, TileEntityDrawers tile, BlockState state, int slot, Direction side, float partialTickTime) {
        int drawerCount = ((BlockDrawers)state.func_177230_c()).getDrawerCount();
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.labelGeometry[slot];
        GlStateManager.pushMatrix();
        this.alignRendering(side);
        float scaleX = (float)labelGeometry.func_216364_b() / 16.0f;
        float scaleY = (float)labelGeometry.func_216360_c() / 16.0f;
        float moveX = (float)labelGeometry.field_72340_a;
        float moveY = 16.0f - (float)labelGeometry.field_72337_e;
        float moveZ = (float)labelGeometry.field_72339_c * 0.0625f;
        this.moveRendering(scaleX, scaleY, moveX, moveY, moveZ);
        GlStateManager.pushMatrix();
        if (drawerCount == 1) {
            GlStateManager.scalef((float)2.6f, (float)2.6f, (float)1.0f);
            GlStateManager.rotatef((float)171.6f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)84.9f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.scalef((float)1.92f, (float)1.92f, (float)1.0f);
            GlStateManager.rotatef((float)169.2f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)79.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
        GlStateManager.enableCull();
        GlStateManager.disableRescaleNormal();
        GlStateManager.enablePolygonOffset();
        GlStateManager.polygonOffset((float)-1.0f, (float)-1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.disableRescaleNormal();
        GlStateManager.pushLightingAttributes();
        GlStateManager.enableRescaleNormal();
        GlStateManager.popAttributes();
        try {
            this.renderItem.func_175042_a(itemStack, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.disablePolygonOffset();
        GlStateManager.popMatrix();
    }

    private boolean isItemBlockType(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof BlockItem && this.renderItem.func_175050_a(itemStack);
    }

    private void alignRendering(Direction side) {
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)this.getRotationYForSide2D(side), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    private void moveRendering(float scaleX, float scaleY, float offsetX, float offsetY, float offsetZ) {
        GlStateManager.translatef((float)0.0f, (float)1.0f, (float)(1.0f - offsetZ));
        GlStateManager.scalef((float)0.0625f, (float)-0.0625f, (float)1.0E-5f);
        GlStateManager.translatef((float)offsetX, (float)offsetY, (float)0.0f);
        GlStateManager.scalef((float)scaleX, (float)scaleY, (float)1.0f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }
}

