/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import net.minecraft.block.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class CompiledPalette {
    private final Map<Character, Object> palette = new HashMap<Character, Object>();
    private final Map<BlockState, BlockState> damagedToBlock = new HashMap<BlockState, BlockState>();
    private final Map<Character, Info> information = new HashMap<Character, Info>();

    public CompiledPalette(CompiledPalette other, Palette ... palettes) {
        this.palette.putAll(other.palette);
        this.damagedToBlock.putAll(other.damagedToBlock);
        this.information.putAll(other.information);
        this.addPalettes(palettes);
    }

    public CompiledPalette(Palette ... palettes) {
        this.addPalettes(palettes);
    }

    private int addEntries(BlockState[] randomBlocks, int idx, BlockState c, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            if (idx >= randomBlocks.length) {
                return idx;
            }
            randomBlocks[idx++] = c;
        }
        return idx;
    }

    public void addPalettes(Palette[] palettes) {
        for (Palette p : palettes) {
            for (Map.Entry<Character, Object> entry : p.palette.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof BlockState) {
                    this.palette.put(entry.getKey(), object);
                    continue;
                }
                if (object instanceof Pair[]) {
                    Pair pair;
                    Pair[] r = (Pair[])object;
                    BlockState[] randomBlocks = new BlockState[128];
                    int idx = 0;
                    Pair[] pairArray = r;
                    int n = pairArray.length;
                    for (int i = 0; i < n && (idx = this.addEntries(randomBlocks, idx, (BlockState)(pair = pairArray[i]).getRight(), (Integer)pair.getLeft())) < randomBlocks.length; ++i) {
                    }
                    this.palette.put(entry.getKey(), randomBlocks);
                    continue;
                }
                if (object instanceof String) continue;
                if (object == null) {
                    throw new RuntimeException("Invalid palette entry for '" + entry.getKey() + "'!");
                }
                this.palette.put(entry.getKey(), object);
            }
        }
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            for (Palette p : palettes) {
                for (Map.Entry<Object, Object> entry : p.palette.entrySet()) {
                    char c;
                    Object value = entry.getValue();
                    if (!(value instanceof String) || !this.palette.containsKey(Character.valueOf(c = ((String)value).charAt(0))) || this.palette.containsKey(entry.getKey())) continue;
                    Object s = this.palette.get(Character.valueOf(c));
                    this.palette.put((Character)entry.getKey(), s);
                    dirty = true;
                }
            }
        }
        for (Palette p : palettes) {
            Object c;
            for (Map.Entry<Object, Object> entry : p.getDamaged().entrySet()) {
                c = (BlockState)entry.getKey();
                this.damagedToBlock.put((BlockState)c, (BlockState)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.getMobIds().entrySet()) {
                c = (Character)entry.getKey();
                this.information.put((Character)c, new Info((String)entry.getValue(), null, false));
            }
            for (Map.Entry<Object, Object> entry : p.getLootTables().entrySet()) {
                c = (Character)entry.getKey();
                this.information.put((Character)c, new Info(null, (String)entry.getValue(), false));
            }
            for (Character c2 : p.getTorches()) {
                this.information.put(c2, new Info(null, null, true));
            }
        }
    }

    public Set<Character> getCharacters() {
        return this.palette.keySet();
    }

    public BlockState getStraight(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                return (BlockState)o;
            }
            if (o instanceof Character) {
                throw new IllegalStateException("BAD!");
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return randomBlocks[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSimple(char c) {
        Object o = this.palette.get(Character.valueOf(c));
        return o instanceof Character;
    }

    public BlockState get(char c, Random rand) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                return (BlockState)o;
            }
            if (o == null) {
                return null;
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return randomBlocks[rand.nextInt(128)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BlockState get(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof BlockState) {
                return (BlockState)o;
            }
            if (o == null) {
                return null;
            }
            BlockState[] randomBlocks = (BlockState[])o;
            return randomBlocks[LostCityTerrainFeature.fastrand128()];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BlockState canBeDamagedToIronBars(BlockState b) {
        return this.damagedToBlock.get(b);
    }

    public Info getInfo(Character c) {
        return this.information.get(c);
    }

    public static class Info {
        private final String mobId;
        private final String loot;
        private final boolean isTorch;

        public Info(String mobId, String loot, boolean isTorch) {
            this.mobId = mobId;
            this.loot = loot;
            this.isTorch = isTorch;
        }

        public String getMobId() {
            return this.mobId;
        }

        public String getLoot() {
            return this.loot;
        }

        public boolean isTorch() {
            return this.isTorch;
        }
    }
}

