/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Orientation;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class Highway {
    private static PerlinNoiseGenerator perlinX = null;
    private static PerlinNoiseGenerator perlinZ = null;
    private static Map<ChunkCoord, Integer> xHighwayLevelCache = new HashMap<ChunkCoord, Integer>();
    private static Map<ChunkCoord, Integer> zHighwayLevelCache = new HashMap<ChunkCoord, Integer>();

    private static void makePerlin(long seed) {
        Random random;
        if (perlinX == null) {
            random = new Random(seed);
            perlinX = new PerlinNoiseGenerator(random, 4);
        }
        if (perlinZ == null) {
            random = new Random(seed ^ 0x346762DBL);
            perlinZ = new PerlinNoiseGenerator(random, 4);
        }
    }

    public static void cleanCache() {
        perlinX = null;
        perlinZ = null;
        xHighwayLevelCache.clear();
        zHighwayLevelCache.clear();
    }

    public static int getXHighwayLevel(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Highway.getHighwayLevel(provider, profile, xHighwayLevelCache, cp -> Highway.hasXHighway(cp, profile), Orientation.X, new ChunkCoord(provider.getType(), chunkX, chunkZ));
    }

    public static int getZHighwayLevel(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        return Highway.getHighwayLevel(provider, profile, zHighwayLevelCache, cp -> Highway.hasZHighway(cp, profile), Orientation.Z, new ChunkCoord(provider.getType(), chunkX, chunkZ));
    }

    private static int getHighwayLevel(IDimensionInfo provider, LostCityProfile profile, Map<ChunkCoord, Integer> cache, Function<ChunkCoord, Boolean> hasHighway, Orientation orientation, ChunkCoord cp) {
        if (cache.containsKey(cp)) {
            return cache.get(cp);
        }
        int mask = profile.HIGHWAY_DISTANCE_MASK;
        if (mask <= 0) {
            cache.put(cp, -1);
            return -1;
        }
        if ((cp.getCoord(orientation.getOpposite()) & mask) != 0) {
            cache.put(cp, -1);
            return -1;
        }
        if (provider.getProfile().isSpace() && CitySphere.intersectsWithCitySphere(cp.getChunkX(), cp.getChunkZ(), provider)) {
            cache.put(cp, -1);
            return -1;
        }
        Highway.makePerlin(provider.getSeed());
        if (hasHighway.apply(cp).booleanValue()) {
            ChunkCoord lower = cp.lower(orientation);
            while (hasHighway.apply(lower).booleanValue()) {
                lower = lower.lower(orientation);
            }
            lower = lower.higher(orientation);
            ChunkCoord higher = cp.higher(orientation);
            while (hasHighway.apply(higher).booleanValue()) {
                higher = higher.higher(orientation);
            }
            higher = higher.lower(orientation);
            int level = -1;
            if (higher.getCoord(orientation) - lower.getCoord(orientation) >= 5) {
                boolean valid;
                if (profile.HIGHWAY_REQUIRES_TWO_CITIES) {
                    valid = BuildingInfo.isCityRaw(lower.getChunkX(), lower.getChunkZ(), provider, profile) && BuildingInfo.isCityRaw(higher.getChunkX(), higher.getChunkZ(), provider, profile);
                } else {
                    boolean bl = valid = BuildingInfo.isCityRaw(lower.getChunkX(), lower.getChunkZ(), provider, profile) || BuildingInfo.isCityRaw(higher.getChunkX(), higher.getChunkZ(), provider, profile);
                }
                if (valid) {
                    switch (profile.HIGHWAY_LEVEL_FROM_CITIES_MODE) {
                        case 0: {
                            level = BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider);
                            break;
                        }
                        case 1: {
                            level = Math.min(BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider), BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider));
                            break;
                        }
                        case 2: {
                            level = Math.max(BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider), BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider));
                            break;
                        }
                        case 3: {
                            level = (BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider) + BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider)) / 2;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Bad value for 'highwayLevelFromCities'!");
                        }
                    }
                    ChunkCoord cc = lower;
                    while (cc.getCoord(orientation) <= higher.getCoord(orientation)) {
                        cache.put(cc, level);
                        cc = cc.higher(orientation);
                    }
                }
            }
            return level;
        }
        cache.put(cp, -1);
        return -1;
    }

    private static boolean hasXHighway(ChunkCoord cp, LostCityProfile profile) {
        return perlinX.func_151601_a((double)((float)cp.getChunkX() / profile.HIGHWAY_MAINPERLIN_SCALE), (double)((float)cp.getChunkZ() / profile.HIGHWAY_SECONDARYPERLIN_SCALE)) > (double)profile.HIGHWAY_PERLIN_FACTOR;
    }

    private static boolean hasZHighway(ChunkCoord cp, LostCityProfile profile) {
        return perlinZ.func_151601_a((double)((float)cp.getChunkX() / profile.HIGHWAY_SECONDARYPERLIN_SCALE), (double)((float)cp.getChunkZ() / profile.HIGHWAY_MAINPERLIN_SCALE)) > (double)profile.HIGHWAY_PERLIN_FACTOR;
    }
}

