/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.DimensionType;

public class DefaultDimensionInfo
implements IDimensionInfo {
    private IWorld world;
    private final LostCityProfile profile;
    private final WorldStyle style;
    private final LostCityTerrainFeature feature;

    public DefaultDimensionInfo(IWorld world, LostCityProfile profile) {
        this.world = world;
        this.profile = profile;
        this.style = AssetRegistries.WORLDSTYLES.get("standard");
        this.feature = new LostCityTerrainFeature(this, profile, this.getRandom());
        this.feature.setupStates(profile);
    }

    @Override
    public void setWorld(IWorld world) {
        this.world = world;
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public DimensionType getType() {
        return this.world.func_201675_m().func_186058_p();
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return null;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.world.func_201674_k();
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        return this.feature.getHeightmap(chunkX, chunkZ, this.getWorld());
    }

    @Override
    public Biome[] getBiomes(int chunkX, int chunkZ) {
        BiomeProvider biomeProvider = this.getWorld().func_72863_F().func_201711_g().func_202090_b();
        return biomeProvider.func_201537_a((chunkX - 1) * 4 - 2, chunkZ * 4 - 2, 10, 10, false);
    }

    @Override
    public Biome getBiome(BlockPos pos) {
        BiomeProvider biomeProvider = this.getWorld().func_72863_F().func_201711_g().func_202090_b();
        return biomeProvider.func_222364_a(pos);
    }
}

