/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATEGORY_PROFILES = "profiles";
    private static final String[] defaultDimensionProfiles = new String[0];
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_PROFILES;
    private static Map<DimensionType, String> dimensionProfileCache;
    public static String profileFromClient;
    public static String jsonFromClient;
    public static ForgeConfigSpec.ConfigValue<String> SELECTED_PROFILE;
    public static ForgeConfigSpec.ConfigValue<String> SELECTED_CUSTOM_JSON;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    private static final ForgeConfigSpec.Builder SERVER_BUILDER;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec SERVER_CONFIG;

    public static String getProfileForDimension(DimensionType type) {
        if (dimensionProfileCache == null) {
            String profile;
            dimensionProfileCache = new HashMap<DimensionType, String>();
            for (String dp : (List)DIMENSION_PROFILES.get()) {
                String[] split = dp.split("=");
                if (split.length != 2) {
                    LostCities.getLogger().error("Bad format for config value: '" + dp + "'!");
                    continue;
                }
                DimensionType dimensionType = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(split[0]));
                if (dimensionType != null) {
                    String profileName = split[1];
                    LostCityProfile profile2 = LostCityConfiguration.standardProfiles.get(profileName);
                    if (profile2 != null) {
                        dimensionProfileCache.put(dimensionType, profileName);
                        continue;
                    }
                    LostCities.getLogger().error("Cannot find profile: " + profileName + " for dimension " + split[0] + "!");
                    continue;
                }
                LostCities.getLogger().error("Cannot find dimension: " + split[0] + "!");
            }
            String selectedProfile = (String)SELECTED_PROFILE.get();
            if ("<CHECK>".equals(selectedProfile)) {
                if (profileFromClient != null && !profileFromClient.isEmpty()) {
                    SELECTED_PROFILE.set((Object)profileFromClient);
                    if (jsonFromClient != null && !jsonFromClient.isEmpty()) {
                        SELECTED_CUSTOM_JSON.set((Object)jsonFromClient);
                    } else {
                        SELECTED_CUSTOM_JSON.set((Object)"");
                    }
                    selectedProfile = profileFromClient;
                } else {
                    SELECTED_PROFILE.set((Object)"");
                    selectedProfile = "";
                }
            }
            if (!selectedProfile.isEmpty()) {
                dimensionProfileCache.put(DimensionType.field_223227_a_, selectedProfile);
                String json = (String)SELECTED_CUSTOM_JSON.get();
                if (json != null && !json.isEmpty()) {
                    LostCityProfile profile3 = new LostCityProfile("customized", json);
                    if (!LostCityConfiguration.standardProfiles.containsKey("customized")) {
                        LostCityConfiguration.standardProfiles.put("customized", new LostCityProfile("customized", false));
                    }
                    LostCityConfiguration.standardProfiles.get("customized").copyFrom(profile3);
                }
            }
            if ((profile = Config.getProfileForDimension(DimensionType.field_223227_a_)) != null && !profile.isEmpty() && LostCityConfiguration.standardProfiles.get((Object)profile).GENERATE_NETHER) {
                dimensionProfileCache.put(DimensionType.field_223228_b_, "cavern");
            }
        }
        return dimensionProfileCache.get(type);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        dimensionProfileCache = null;
        profileFromClient = null;
        jsonFromClient = null;
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        CLIENT_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        SERVER_BUILDER.comment("General settings").push(CATEGORY_PROFILES);
        DIMENSION_PROFILES = COMMON_BUILDER.comment("A list of dimensions with associated city generation profiles").defineList("dimensionProfiles", (List)Lists.newArrayList((Object[])defaultDimensionProfiles), s -> s instanceof String);
        SELECTED_PROFILE = SERVER_BUILDER.define("selectedProfile", (Object)"<CHECK>");
        SELECTED_CUSTOM_JSON = SERVER_BUILDER.define("selectedCustomJson", (Object)"");
        SERVER_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        SERVER_CONFIG = SERVER_BUILDER.build();
    }
}

