/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;

public class NullDimensionInfo
implements IDimensionInfo {
    private final String[] biomeMap = new String[]{"ddddddddddddddddddddddppppppppppppppp==ppppppppppp", "ddddddddddddddddddddpppppppppppppppp==pppppppppppp", "ddddddddddddddddddddpppppppppppppp===ppppppppppppp", "pddddddddddddddddpppppppppppppppppp==ppppppppppppp", "pppdddddddppppppppppppppppppppppppp==ppppppppppppp", "pppppppppppppppppppppppppppppppppppp==pppppppppp--", "ppppppppppppppppppppppppppppppppppppp==ppppppp----", "pppppppppppppppppppppppppppppppppppppp==ppppp-----", "pppppppppppppppppppppppppppppppppppppp===pppp-----", "ppppppppppppppppppppppppppppppppppppppp===ppppp---", "pppppppppppppppppppppppppppppppppppppppp==--pp----", "pppppppppppppppppppppppppppppppppppppppp*---------", "pppppppppppppppppppppppppppppppppppppp****--------", "ppppppppppppppppppppppppppppppppppppp***----------", "pppppppppppppppppppppppppppppppppppp**------------", "ppppppppppppppppppppppppppppppppppppp**-----------", "ppppppppppppppppppppppppppppppppppppppp*----------", "pppppppppppppppppppppppppppppppppppppp**----------", "ppppp###pppppppppppppppppppppppppppppp**----------", "ppppp####ppppppp#####pppppppppppppppppp*----------", "pppppp#####pp##+++#####ppppppppppppp*****---------", "pppppppp#####++++####pppppppppppppp**------pp----p", "ppppppppp##++++++###pppppppppppppppp***---pppp--pp", "ppppppppp###+++++++#####ppppppppppppp---pppppppppp", "pppppppp##p##+++++++###ppppppppppppppppppppppppppp", "pppppppppp#####++++####ppppppppppppppppppppppppppp", "pppppppppppp###+++++###ppppppppppppppppppppppppppp", "ppppppppppppp####++++####ppppppppppppppppppppppppp", "pppppppppppppp####++######pppppppppppppppppppppppp", "ppppppppppppppp#+++####ppppppppppppppppppppppppppp", "ppppppppppppp####pp#####pppppppppppppppppppppppppp", "pppppppppp#####ppppppppppppppppppppppppppppppppppp", "ppppppppppp###pppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppp"};
    private final LostCityProfile profile;
    private final WorldStyle style;
    private final Random random;
    private final long seed;
    private final LostCityTerrainFeature feature;

    public NullDimensionInfo(LostCityProfile profile, long seed) {
        this.profile = profile;
        this.style = AssetRegistries.WORLDSTYLES.get("standard");
        this.seed = seed;
        this.random = new Random(seed);
        this.feature = new LostCityTerrainFeature(this, profile, this.getRandom());
        this.feature.setupStates(profile);
    }

    @Override
    public void setWorld(IWorld world) {
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public IWorld getWorld() {
        return null;
    }

    @Override
    public DimensionType getType() {
        return DimensionType.field_223227_a_;
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return null;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        ChunkHeightmap heightmap = new ChunkHeightmap(this.profile.LANDSCAPE_TYPE, this.profile.GROUNDLEVEL, this.getFeature().base);
        char b = this.getBiomeChar(chunkX, chunkZ);
        int y = 65;
        switch (b) {
            case 'p': {
                y = 65;
                break;
            }
            case '-': {
                y = 60;
                break;
            }
            case '=': {
                y = 65;
                break;
            }
            case '#': {
                y = 95;
                break;
            }
            case '+': {
                y = 125;
                break;
            }
            case '*': {
                y = 65;
                break;
            }
            case 'd': {
                y = 65;
            }
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                heightmap.update(x, y, z, this.getFeature().base);
            }
        }
        return heightmap;
    }

    public char getBiomeChar(int chunkX, int chunkZ) {
        if (chunkX >= 0 && chunkX < 50 && chunkZ >= 0 && chunkZ < 50) {
            return this.biomeMap[chunkZ].charAt(chunkX);
        }
        return 'p';
    }

    @Override
    public Biome[] getBiomes(int chunkX, int chunkZ) {
        Biome[] biomes = new Biome[100];
        Biome biome = Biomes.field_76772_c;
        char b = this.getBiomeChar(chunkX, chunkZ);
        switch (b) {
            case 'p': {
                biome = Biomes.field_76772_c;
                break;
            }
            case '-': {
                biome = Biomes.field_76771_b;
                break;
            }
            case '=': {
                biome = Biomes.field_76781_i;
                break;
            }
            case '#': {
                biome = Biomes.field_76783_v;
                break;
            }
            case '+': {
                biome = Biomes.field_76770_e;
                break;
            }
            case '*': {
                biome = Biomes.field_76787_r;
                break;
            }
            case 'd': {
                biome = Biomes.field_76769_d;
            }
        }
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = biome;
        }
        return biomes;
    }

    @Override
    public Biome getBiome(BlockPos pos) {
        Biome biome = Biomes.field_76772_c;
        ChunkPos cp = new ChunkPos(pos);
        char b = this.getBiomeChar(cp.field_77276_a, cp.field_77275_b);
        switch (b) {
            case 'p': {
                biome = Biomes.field_76772_c;
                break;
            }
            case '-': {
                biome = Biomes.field_76771_b;
                break;
            }
            case '=': {
                biome = Biomes.field_76781_i;
                break;
            }
            case '#': {
                biome = Biomes.field_76783_v;
                break;
            }
            case '+': {
                biome = Biomes.field_76770_e;
                break;
            }
            case '*': {
                biome = Biomes.field_76787_r;
                break;
            }
            case 'd': {
                biome = Biomes.field_76769_d;
            }
        }
        return biome;
    }
}

