/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import net.minecraft.world.WorldType;

public class LostCitySetup {
    public static final LostCitySetup CLIENT_SETUP = new LostCitySetup(() -> {});
    private List<String> profiles = null;
    private String profile = null;
    private LostCityProfile customizedProfile = null;
    private final Runnable refreshPreview;

    public LostCitySetup(Runnable refreshPreview) {
        this.refreshPreview = refreshPreview;
    }

    public LostCityProfile getCustomizedProfile() {
        return this.customizedProfile;
    }

    public boolean isCustomizable() {
        if (this.profile == null) {
            return false;
        }
        return !"customized".equals(this.profile);
    }

    public String getProfile() {
        return this.profile;
    }

    public String getProfileLabel() {
        return this.profile == null ? "Disabled" : this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.refreshPreview.run();
    }

    public void copyFrom(LostCitySetup other) {
        this.profile = other.profile;
        this.customizedProfile = other.customizedProfile;
    }

    public void customize() {
        if (this.profile == null) {
            throw new IllegalStateException("Cannot happen!");
        }
        this.customizedProfile = new LostCityProfile("customized", false);
        LostCityProfile original = LostCityConfiguration.standardProfiles.get(this.profile);
        LostCityConfiguration.standardProfiles.put("customized", this.customizedProfile);
        this.profiles.add("customized");
        this.customizedProfile.copyFrom(original);
        this.profile = "customized";
        this.refreshPreview.run();
    }

    public Optional<LostCityProfile> get() {
        if (this.profile == null) {
            return Optional.empty();
        }
        if ("customized".equals(this.profile)) {
            return Optional.ofNullable(this.customizedProfile);
        }
        return Optional.of(LostCityConfiguration.standardProfiles.get(this.profile));
    }

    public void toggleProfile(WorldType worldType) {
        int i;
        if (this.profiles == null) {
            String preferedProfile = "default";
            if ("lc_cavern".equals(worldType.func_211888_a())) {
                preferedProfile = "cavern";
            }
            this.profiles = new ArrayList<String>(LostCityConfiguration.standardProfiles.keySet());
            String finalPreferedProfile = preferedProfile;
            this.profiles.sort((o1, o2) -> {
                if (finalPreferedProfile.equals(o1)) {
                    return -1;
                }
                if (finalPreferedProfile.equals(o2)) {
                    return 1;
                }
                return o1.compareTo((String)o2);
            });
        }
        this.profile = this.profile == null ? this.profiles.get(0) : ((i = this.profiles.indexOf(this.profile)) == -1 || i >= this.profiles.size() - 1 ? null : this.profiles.get(i + 1));
        this.refreshPreview.run();
    }
}

