/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;

public class CommandMap
implements Command<CommandSource> {
    private static final CommandMap CMD = new CommandMap();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"map").requires(cs -> cs.func_197034_c(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        if (player != null) {
            BlockPos position = player.func_180425_c();
            IDimensionInfo dimInfo = Registration.LOSTCITY_FEATURE.getDimensionInfo((IWorld)player.func_71121_q());
            if (dimInfo != null) {
                ChunkPos pos = new ChunkPos(position);
                for (int z = pos.field_77275_b - 40; z <= pos.field_77275_b + 40; ++z) {
                    String buf = "";
                    for (int x = pos.field_77276_a - 40; x <= pos.field_77276_a + 40; ++x) {
                        BuildingInfo info = BuildingInfo.getBuildingInfo(pos.field_77276_a + x, pos.field_77275_b + z, dimInfo);
                        buf = info.isCity && info.hasBuilding ? buf + "B" : (info.isCity ? buf + "+" : (info.highwayXLevel >= 0 || info.highwayZLevel >= 0 ? buf + "." : buf + " "));
                    }
                    System.out.println(buf);
                }
            }
        }
        return 0;
    }
}

